/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.devicecenter.exception.ExcelParseException;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static String getCellStrVal(Row row, int ii) throws ExcelParseException {
        if (row == null) {
            return "";
        }
        return ExcelUtils.readCellVal(row, row.getCell(ii));
    }

    private static String readCellVal(Row row, Cell cell) throws ExcelParseException {
        if (cell == null) {
            return "";
        }
        CellType cellTypeEnum = cell.getCellType();
        if (CellType.NUMERIC.equals((Object)cellTypeEnum)) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", LocaleUtil.getUserLocale());
                sdf.setTimeZone(LocaleUtil.getUserTimeZone());
                return sdf.format(cell.getDateCellValue());
            }
            return StringUtils.removeEnd((String)String.valueOf((int)cell.getNumericCellValue()), (String)".0");
        }
        if (CellType.BLANK.equals((Object)cellTypeEnum)) {
            return "";
        }
        if (CellType.BOOLEAN.equals((Object)cellTypeEnum)) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (CellType.FORMULA.equals((Object)cellTypeEnum)) {
            FormulaEvaluator fe = row.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
            return ExcelUtils.readCellVal(row, fe.evaluateInCell(cell));
        }
        if (!CellType.STRING.equals((Object)cellTypeEnum)) {
            throw new ExcelParseException("device.import.error.public.formatIsError", row.getSheet().getSheetName(), ExcelUtils.getCellAddress(row.getRowNum(), cell.getColumnIndex()));
        }
        return StringUtils.trimToEmpty((String)cell.toString());
    }

    public static String getCellStrValAndRemoveEnd(Row row, short colIndex, String end) throws ExcelParseException {
        return StringUtils.removeEnd((String)ExcelUtils.getCellStrVal(row, colIndex), (String)end);
    }

    public static String getCellAddress(int rowIndex, int colIndex) {
        if (colIndex < 0) {
            if (rowIndex < 0) {
                return "";
            }
            return String.valueOf(rowIndex);
        }
        return CellReference.convertNumToColString((int)colIndex) + (rowIndex + 1);
    }

    public static boolean isBlankRow(Row row) {
        if (row == null) {
            return true;
        }
        Iterator it = row.cellIterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (cell == null || CellType.BLANK == cell.getCellType()) continue;
            return false;
        }
        return true;
    }

    public static Workbook getWorkBook(File excelFile) {
        Object workbook = null;
        try (FileInputStream is = new FileInputStream(excelFile);){
            workbook = excelFile.getName().endsWith(".xlsx") ? new XSSFWorkbook((InputStream)is) : new HSSFWorkbook((InputStream)is);
        }
        catch (FileNotFoundException e) {
            log.error("file:{} not found.", (Object)excelFile.getName());
        }
        catch (IOException e) {
            log.error("get workbook io exception.", (Throwable)e);
        }
        return workbook;
    }

    public static boolean isSomeSheetRowNumIsLegal(Workbook workbook, int maxNum, List<String> sheets) {
        int sheetAllCount = 0;
        if (workbook == null) {
            log.error("workbook is null.");
            return false;
        }
        int sheetNum = workbook.getNumberOfSheets();
        for (int sheetIdx = 0; sheetIdx < sheetNum; ++sheetIdx) {
            String sheetName = workbook.getSheetName(sheetIdx);
            if (!sheets.contains(sheetName)) continue;
            sheetAllCount += POIUtils.getSheetNotEmptyRowNum(workbook.getSheetAt(sheetIdx));
        }
        return sheetAllCount <= maxNum;
    }

    public static Workbook getWorkbook(String sheetName, List<String> headers, List<List<String>> body) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(sheetName);
        Row headerRow = sheet.createRow(0);
        CellStyle headerStyle = workbook.createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        for (int i = 0; i < headers.size(); ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers.get(i));
            cell.setCellStyle(headerStyle);
        }
        for (int rowIndex = 1; rowIndex <= body.size(); ++rowIndex) {
            List<String> rowData = body.get(rowIndex - 1);
            Row dataRow = sheet.createRow(rowIndex);
            for (int columnIndex = 0; columnIndex < rowData.size(); ++columnIndex) {
                Cell cell = dataRow.createCell(columnIndex);
                cell.setCellValue(rowData.get(columnIndex));
            }
        }
        IntStream.range(0, headers.size()).forEach(arg_0 -> ((Sheet)sheet).autoSizeColumn(arg_0));
        return workbook;
    }
}

