/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.enums.ParseXlsCheckType;
import com.huawei.ism.tool.devicecenter.exception.ExcelParseException;
import com.huawei.ism.tool.devicecenter.utils.ExcelUtils;
import com.huawei.ism.tool.devicecenter.utils.ServerParser;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.Frame;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDeviceInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(ImportDeviceInfoUtil.class);
    private static final String DEV_LIST_FILEID = "device_manage_export_devcelist_001";

    public static List<AbstractDevice> getImportDeviceList(File importFile) {
        if (!ImportDeviceInfoUtil.isPassForCheckImportDeviceFile(importFile)) {
            return Collections.emptyList();
        }
        return ImportDeviceInfoUtil.parseFileToDevice(importFile);
    }

    public static File chooseFile(String fileChooserTitle) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", "*.xls;*.xlsx");
        extParams.put("PathId", DEV_LIST_FILEID);
        extParams.put("title", fileChooserTitle);
        return ToolFileChooser.selectFile((Window)DeviceCenterContext.getInstance().getParent(), new String[]{"xls", "xlsx"}, 0, true, extParams);
    }

    private static List<AbstractDevice> parseFileToDevice(File importFile) {
        List<AbstractDevice> abstratDeviceList = Collections.emptyList();
        try {
            ServerParser serverParse = new ServerParser(importFile);
            abstratDeviceList = serverParse.parseServerByExcel();
            log.info("finish parsing hwserver from excel");
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.sensitiveInfoTip"));
        }
        catch (ExcelParseException e1) {
            log.error("parse excel failed", (Throwable)e1);
            ImportDeviceInfoUtil.checkExcelFormat(e1);
        }
        return abstratDeviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPassForCheckImportDeviceFile(File importFile) {
        Workbook workBook = ExcelUtils.getWorkBook(importFile);
        try {
            int serverMaxNum = Integer.parseInt(ApplicationContext.getInstance().getAppConfig("app.devicecenter.excel.max.num").trim());
            String shouldCalRowNumName = ResourceUtil.getString((String)"devicecenter.device.import.excel.sheet.row.num.calculation.names", (Locale)Locale.CHINESE);
            String[] sheetNames = shouldCalRowNumName.split(",");
            if (!ExcelUtils.isSomeSheetRowNumIsLegal(workBook, serverMaxNum, Arrays.asList(sheetNames))) {
                DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getStringWithParams((String)"devicecenter.device.import.excel.max.num.tips", (Object[])new Object[]{String.valueOf(serverMaxNum)}));
                log.error("the number of imported template {} records exceeds the upper limit.", (Object)importFile.getName());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)workBook);
        }
    }

    private static void checkExcelFormat(ExcelParseException e1) {
        String message = ImportDeviceInfoUtil.getExcelMessage(e1);
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)message)) {
            message = e1.getMessage();
        }
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)message)) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)message);
        }
    }

    private static String getExcelMessage(ExcelParseException excelParseException) {
        if (excelParseException.getErrType() == ParseXlsCheckType.PORT_NOTNUM) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.portNotNum", (Object[])new Object[]{excelParseException.getSheet(), excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.START_FORMAT_EQUAL_END) {
            return ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.start.format.equal.end");
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.STARTENDIP_NOT_LEGAL) {
            String[] ipCols = excelParseException.getColNum().split(",");
            if (ipCols.length < 2) {
                return "";
            }
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.startEndIpTips", (Object[])new Object[]{excelParseException.getSheet(), ipCols[0] + excelParseException.getRowNum(), ipCols[1] + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.EXCEL_NOT_LEGAL) {
            return ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.notlegal");
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.START_BIGGER_THAN_END) {
            return ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.start.mustLessThan.end");
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.HMMNODE_NOT_CONTAIN_IN_DEV) {
            return ResourceUtil.getString((String)"devicecenter.batchimport.parse.devips.contain.nodeips");
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.NODE_CAN_NOTNULL) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.hmm.mustfield.notnull", (Object[])new Object[]{excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.NODE_SLOT_ERROR) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.hmm.nodeslot.error", (Object[])new Object[]{excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.NODE_PORT_NOTNUM) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.hmm.nodeport.notnum", (Object[])new Object[]{excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.NODE_PORT_ERROR) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.hmm.nodesport.beyond", (Object[])new Object[]{excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        return ImportDeviceInfoUtil.createExcelErrorMsg(excelParseException);
    }

    private static String createExcelErrorMsg(ExcelParseException excelParseException) {
        if (excelParseException.getErrType() == ParseXlsCheckType.IP_NOT_LEGAL) {
            String[] ipCols = excelParseException.getColNum().split(",");
            if (ipCols.length < 2) {
                return "";
            }
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.ipnotok.Tips", (Object[])new Object[]{excelParseException.getSheet(), ipCols[0] + excelParseException.getRowNum(), ipCols[1] + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.START_FORMAT_EQUAL_END) {
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.start.format.equal.end", (Object[])new Object[]{excelParseException.getSheet(), excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.NO_DEVDATA) {
            return ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.hasNoDevData");
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.CAN_NOTNULL) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.excelModel.field.mustFill", (Object[])new Object[]{excelParseException.getSheet(), excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.PROXY_NOT_LEGAL) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.excelModel.field.proxylegal", (Object[])new Object[]{excelParseException.getSheet(), excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.PROXY_STARTENDIP_NOT_SAME) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.startEndIpProxy", (Object[])new Object[]{excelParseException.getSheet(), excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.PORT_ERROR) {
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.excelModel.field.portError", (Object[])new Object[]{excelParseException.getSheet(), excelParseException.getColNum() + excelParseException.getRowNum()});
        }
        if (excelParseException.getErrType() == ParseXlsCheckType.IP_CANNOT_ENDWITH255OR0) {
            String[] ipCols = excelParseException.getColNum().split(",");
            if (ipCols.length < 2) {
                return "";
            }
            return ResourceUtil.getStringWithParams((String)"devicecenter.batchimport.parse.excelModel.field.ipendWith255or0", (Object[])new Object[]{excelParseException.getSheet(), ipCols[0] + excelParseException.getRowNum(), ipCols[1] + excelParseException.getRowNum()});
        }
        return "";
    }

    public static boolean isUpgradePrepare() {
        try {
            String jsonSceneArgsList = System.getenv("jsonSceneArgsList");
            if (StringUtils.isNULLStr(jsonSceneArgsList)) {
                return false;
            }
            JSONObject jsonScenes = new JSONObject(jsonSceneArgsList);
            String scene = jsonScenes.getStringOrDefault("toolDescription", "");
            return "UpgradePrepare".equals(scene);
        }
        catch (JSONException e) {
            log.error("Failed to obtain tool scene.", (Throwable)e);
            return false;
        }
    }
}

