/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.ui.dialog.DevWhiteListDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.IbmcDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OsDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SwitchDeviceAddLayOut;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.util.NetUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LayUtil {
    public static final int COLOR_NUM = 16729404;
    public static final double DOUBLE6P5 = 6.5;
    private static final List<ITDeviceType> snFilterDevType = Arrays.asList(ITDeviceType.IES, ITDeviceType.SERVER_OS, ITDeviceType.SERVER_IBMC);
    private static final String STR_SEPARATE = ":";
    private static final String STR_ZERO = "0";
    private static final String STR_ELLIPSIS = "::";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";

    public static GridBagConstraints buildGrabBagConstraints(int xLocation, int yLocation, int width, int height) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = xLocation;
        constraints.gridy = yLocation;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.insets = new Insets(2, 3, 5, 5);
        constraints.anchor = 18;
        return constraints;
    }

    public static GridBagConstraints buildGrabBagConstraintsInset2(int xLocation, int yLocation, int width, int height, Insets inset) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = xLocation;
        constraints.gridy = yLocation;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        if (null != inset) {
            constraints.insets = inset;
        }
        constraints.anchor = 18;
        return constraints;
    }

    public static void setComponentSize(JComponent comp, Dimension size) {
        comp.setPreferredSize(size);
        comp.setMinimumSize(size);
        comp.setMaximumSize(size);
        comp.setSize(size);
    }

    public static String filterItemInfo(String str) {
        if (StringUtils.isNULLStr((String)str)) {
            return "";
        }
        return str;
    }

    public static void setComponentSameMaxWidthSize(JComponent ... comps) {
        Dimension maxSize = null;
        for (JComponent comp : comps) {
            if (null == maxSize) {
                maxSize = comp.getMaximumSize();
            }
            if (maxSize.width >= comp.getMaximumSize().width) continue;
            maxSize = comp.getMaximumSize();
        }
        for (JComponent com : comps) {
            UiMethod.setComponentSize(maxSize, com);
        }
    }

    public static boolean isStartIpLessEnd(String start, String end) {
        String[] starts = new String[]{};
        String[] ends = new String[]{};
        String normalizedStart = Normalizer.normalize(start, Normalizer.Form.NFKC);
        String normalizedEnd = Normalizer.normalize(end, Normalizer.Form.NFKC);
        if (normalizedStart.contains(".") && normalizedEnd.contains(".")) {
            starts = normalizedStart.split("\\.");
            ends = normalizedEnd.split("\\.");
        }
        long startIpNum = 0L;
        long endIpNum = 0L;
        for (int i = 0; i < 4; ++i) {
            int s = Integer.valueOf(starts[i]);
            int e = Integer.valueOf(ends[i]);
            startIpNum = (long)((double)startIpNum + (double)s * Math.pow(255.0, 3 - i));
            endIpNum = (long)((double)endIpNum + (double)e * Math.pow(255.0, 3 - i));
        }
        return startIpNum <= endIpNum;
    }

    public static boolean isIpv6StartIpLessEnd(String start, String end) {
        String[] startStringArray = LayUtil.ipv6ToStringArray(start);
        String[] endStringArray = LayUtil.ipv6ToStringArray(end);
        int[] startIntArray = LayUtil.ipv6HexToInt(startStringArray);
        int[] endIntArray = LayUtil.ipv6HexToInt(endStringArray);
        return LayUtil.compareTwoArray(startIntArray, endIntArray);
    }

    public static boolean compareTwoArray(int[] frontArray, int[] backArray) {
        int isFrontCompareResult = -1;
        if (frontArray[0] > backArray[0]) {
            isFrontCompareResult = 1;
        }
        if (frontArray[0] == backArray[0]) {
            isFrontCompareResult = 0;
        }
        for (int i = 1; i < 8; ++i) {
            if (isFrontCompareResult == 1) {
                return false;
            }
            if (isFrontCompareResult == -1) {
                return true;
            }
            if (isFrontCompareResult != 0) continue;
            if (frontArray[i] > backArray[i]) {
                isFrontCompareResult = 1;
            }
            if (frontArray[i] == backArray[i]) {
                isFrontCompareResult = 0;
            }
            if (frontArray[i] >= backArray[i]) continue;
            isFrontCompareResult = -1;
        }
        return isFrontCompareResult != 1;
    }

    private static boolean compareFirstSevenParagraphs(int[] startArray, int[] endArray) {
        for (int i = 0; i < 7; ++i) {
            if (startArray[i] == endArray[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] ipv6HexToInt(String[] ipv6StringArray) {
        int[] intArray = new int[8];
        for (int i = 0; i < 8; ++i) {
            intArray[i] = Integer.parseInt(ipv6StringArray[i], 16);
        }
        return intArray;
    }

    public static String[] ipv6IntToHex(int[] ipv6IntArray) {
        String[] strArray = new String[8];
        for (int i = 0; i < 8; ++i) {
            strArray[i] = Integer.toHexString(ipv6IntArray[i]);
        }
        return strArray;
    }

    public static String[] ipv6ToStringArray(String ipv6) {
        String[] ipv6StrArray = new String[8];
        if (ipv6.contains(STR_ELLIPSIS)) {
            String[] ipv6Array = ipv6.split(STR_SEPARATE);
            int length = ipv6Array.length;
            if (ipv6.startsWith(STR_SEPARATE)) {
                LayUtil.initIpv6StrArray(ipv6StrArray, ipv6Array, length);
            } else {
                int i;
                int frontLength = 0;
                int lastLength = 0;
                for (int i2 = 0; i2 < length && !StringUtils.isNULLStr((String)ipv6Array[i2]); ++i2) {
                    ++frontLength;
                }
                lastLength = length - frontLength - 1;
                int count = 0;
                for (i = 0; i < 8; ++i) {
                    if (i < frontLength) {
                        ipv6StrArray[i] = ipv6Array[i];
                        continue;
                    }
                    if (i < 8 - lastLength) {
                        ipv6StrArray[i] = STR_ZERO;
                        continue;
                    }
                    count = i;
                    break;
                }
                for (i = 0; i < 8 - count; ++i) {
                    ipv6StrArray[count + i] = ipv6Array[frontLength + 1 + i];
                }
            }
        } else {
            ipv6StrArray = ipv6.split(STR_SEPARATE);
        }
        return ipv6StrArray;
    }

    private static void initIpv6StrArray(String[] ipv6StrArray, String[] ipv6Array, int length) {
        for (int i = 0; i < 8; ++i) {
            if (i < 10 - length) {
                ipv6StrArray[i] = STR_ZERO;
                continue;
            }
            if (i + length - 8 < 0 || i + length - 8 >= length) continue;
            ipv6StrArray[i] = ipv6Array[i + length - 8];
        }
    }

    public static String checkPort(JPanel lay) {
        JPanel layout;
        String message = "";
        String snmpPort = "";
        String ipmiPort = "";
        String sshSfipPort = "";
        String vmPortPort = "";
        String redFishPort = "";
        if (lay instanceof HmmDeviceAddLayout) {
            layout = (HmmDeviceAddLayout)lay;
            snmpPort = ((HmmDeviceAddLayout)layout).getSnmpPortField().getText();
            ipmiPort = ((HmmDeviceAddLayout)layout).getIpmiPortField().getText();
            sshSfipPort = ((HmmDeviceAddLayout)layout).getSshSfipPortField().getText();
            vmPortPort = ((HmmDeviceAddLayout)layout).getVMPortField().getText();
            redFishPort = ((HmmDeviceAddLayout)layout).getRedfishPortPortField().getText();
        }
        if (lay instanceof IbmcDeviceAddLayout) {
            layout = (IbmcDeviceAddLayout)lay;
            snmpPort = ((IbmcDeviceAddLayout)layout).getSnmpPortField().getText();
            ipmiPort = ((IbmcDeviceAddLayout)layout).getIpmiField().getText();
            sshSfipPort = ((IbmcDeviceAddLayout)layout).getSshSfipField().getText();
            vmPortPort = ((IbmcDeviceAddLayout)layout).getVmField().getText();
            redFishPort = ((IbmcDeviceAddLayout)layout).getRedfishField().getText();
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)snmpPort)) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portMustNum", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.snmp")});
            return message;
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)ipmiPort)) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portMustNum", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.ipmi")});
            return message;
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)sshSfipPort)) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portMustNum", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.sshSfip")});
            return message;
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)vmPortPort)) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portMustNum", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.vm")});
            return message;
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)redFishPort)) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portMustNum", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.redFish")});
            return message;
        }
        if (!SmartkitUtils.isPortLegal(Integer.valueOf(snmpPort))) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portError", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.snmp")});
            return message;
        }
        if (!SmartkitUtils.isPortLegal(Integer.valueOf(ipmiPort))) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portError", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.ipmi")});
            return message;
        }
        if (!SmartkitUtils.isPortLegal(Integer.valueOf(sshSfipPort))) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portError", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.sshSfip")});
            return message;
        }
        if (!SmartkitUtils.isPortLegal(Integer.valueOf(vmPortPort))) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portError", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.vm")});
            return message;
        }
        if (!SmartkitUtils.isPortLegal(Integer.valueOf(redFishPort))) {
            message = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.portError", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.port.redFish")});
            return message;
        }
        return message;
    }

    private static String checkIpv4StratIpAndEndIpFormat(String startIp, String endIp) {
        String message = "";
        if (LayUtil.checkIpV4HasSpecial(startIp)) {
            if (NetUtil.isValidIPV6((String)endIp)) {
                message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.start.format.equal.end");
                return message;
            }
            if (!LayUtil.isStartIpLessEnd(startIp, endIp)) {
                message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.start.mustLessThan.end");
                return message;
            }
            if (!SmartkitUtils.checkIpBefore2NetPart(startIp, endIp)) {
                message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startEnd.before2equal");
                return message;
            }
        }
        return message;
    }

    private static String checkIpv6StratIpAndEndIpFormat(String startIp, String endIp) {
        String message = "";
        if (NetUtil.isValidIPV6((String)startIp)) {
            int[] endIntArray;
            if (NetUtil.isValidIPV4((String)endIp)) {
                message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.start.format.equal.end");
                return message;
            }
            String[] startStringArray = LayUtil.ipv6ToStringArray(startIp);
            String[] endStringArray = LayUtil.ipv6ToStringArray(endIp);
            int[] startIntArray = LayUtil.ipv6HexToInt(startStringArray);
            if (!LayUtil.compareTwoArray(startIntArray, endIntArray = LayUtil.ipv6HexToInt(endStringArray))) {
                message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.start.mustLessThan.end");
                return message;
            }
            if (!LayUtil.compareFirstSevenParagraphs(startIntArray, endIntArray)) {
                message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.ipv6.start.format.equal.end");
                return message;
            }
        }
        return message;
    }

    public static String checkIpAddress(JPanel lay) {
        String message = "";
        String startIp = "";
        String endIp = "";
        boolean isPortProxy = false;
        if (lay instanceof HmmDeviceAddLayout) {
            HmmDeviceAddLayout layout = (HmmDeviceAddLayout)lay;
            startIp = layout.getStartIpAddress().getText();
            endIp = layout.getEndIpField().getText();
            isPortProxy = layout.getPortproxyRadio().getModel().isSelected();
        } else if (lay instanceof IbmcDeviceAddLayout) {
            IbmcDeviceAddLayout layout = (IbmcDeviceAddLayout)lay;
            startIp = layout.getStartIpAddress().getText();
            endIp = layout.getEndIpField().getText();
        } else if (lay instanceof OsDeviceAddLayout) {
            OsDeviceAddLayout layout = (OsDeviceAddLayout)lay;
            startIp = layout.getStartIpAddress().getText();
            endIp = layout.getEndIpField().getText();
        } else if (lay instanceof SwitchDeviceAddLayOut) {
            SwitchDeviceAddLayOut layout = (SwitchDeviceAddLayOut)lay;
            startIp = layout.getStartIpAddress().getText();
            endIp = layout.getEndIpField().getText();
        }
        if (!(!isPortProxy || startIp.equals(endIp) && NetUtil.isValidIPV4((String)startIp))) {
            message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.proxy.invalid");
            return message;
        }
        if (!LayUtil.checkIpForServer(startIp)) {
            message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp.invalid");
            return message;
        }
        if (!LayUtil.checkIpForServer(endIp)) {
            message = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.endIp.invalid");
            return message;
        }
        message = LayUtil.checkIpv4StratIpAndEndIpFormat(startIp, endIp);
        if (!StringUtils.isNULLStr((String)message)) {
            return message;
        }
        message = LayUtil.checkIpv6StratIpAndEndIpFormat(startIp, endIp);
        return message;
    }

    public static boolean checkIpForServer(String ip) {
        if (LOOPBACK_ADDRESS.equals(ip)) {
            return true;
        }
        return NetUtil.isValidIP((String)ip);
    }

    public static boolean checkIpV4HasSpecial(String ip) {
        if (LOOPBACK_ADDRESS.equals(ip)) {
            return true;
        }
        return NetUtil.isValidIPV4((String)ip);
    }

    public static IsmTableCell.TextCell createTextCell(String text) {
        return new IsmTableCell.TextCell(text, false, 0);
    }

    public static String getHmmOrCmmTips(String keyHmm, String keyTce, boolean isTceDev) {
        if (isTceDev) {
            return ResourceUtil.getString((String)keyTce);
        }
        return ResourceUtil.getString((String)keyHmm);
    }

    public static List<AbstractDevice> getTableShouldRefreshDevices(DefaultTableModel tableModel, List<AbstractDevice> argDevices) {
        List<AbstractDevice> tableHasedDevices = tableModel.getAllRows().stream().map(row -> (AbstractDevice)row.getUserObject()).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(tableHasedDevices)) {
            return LayUtil.snWhiteListFilter(argDevices);
        }
        tableHasedDevices.removeAll(argDevices);
        tableHasedDevices.addAll(argDevices);
        return LayUtil.snWhiteListFilter(tableHasedDevices);
    }

    private static List<AbstractDevice> snWhiteListFilter(List<AbstractDevice> argDevices) {
        if (!DeviceCenterContext.isEnableWhiteList()) {
            return argDevices;
        }
        HashSet<String> whiteListSns = new HashSet<String>(DevWhiteListDialog.getSnList());
        return argDevices.stream().filter(dev -> !snFilterDevType.contains((Object)dev.getItDeviceType()) || whiteListSns.contains(dev.getDeviceSn())).collect(Collectors.toList());
    }

    public static void clearTable(DefaultTableModel tableModel) {
        if (!VerifyUtil.isEmpty((Object)tableModel) && !VerifyUtil.isEmpty((Collection)tableModel.getAllRows())) {
            tableModel.removeAll();
        }
    }

    public static boolean hasExistDevice(List<AbstractDevice> argDevices) {
        List<AbstractDevice> contextDevs = DeviceCenterContext.getInstance().getHasedDevicesBeforeRefresh();
        return argDevices.stream().anyMatch(contextDevs::contains);
    }

    public static void getTableExistedDevices(DefaultTableModel tableModel) {
        if (VerifyUtil.isEmpty((Object)tableModel)) {
            return;
        }
        List<AbstractDevice> tableHasedDevices = DeviceCenterContext.getInstance().getHasedDevicesBeforeRefresh();
        List currentTableDevices = tableModel.getAllRows().stream().map(row -> (AbstractDevice)row.getUserObject()).collect(Collectors.toList());
        if (currentTableDevices.isEmpty()) {
            return;
        }
        if (tableHasedDevices.isEmpty()) {
            tableHasedDevices.addAll(currentTableDevices);
        } else {
            tableHasedDevices.removeAll(currentTableDevices);
            tableHasedDevices.addAll(currentTableDevices);
        }
    }

    public static void removeDevFromAllTableDevs(AbstractDevice dev) {
        DeviceCenterContext.getInstance().getHasedDevicesBeforeRefresh().remove(dev);
    }
}

