/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    private LogUtils() {
    }

    public static void addImportLog(String name, String deviceName, boolean success, String detailInfo) {
        OperaLog log = new OperaLog();
        log.setOperaName(name);
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName(deviceName);
        log.setDeviceNameEn(deviceName);
        log.setOperateType("operalog.type.device");
        log.setResult(success);
        log.setDetailInfo(detailInfo);
        ILogSupportService logService = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }

    public static boolean isShowOperationButton() {
        try {
            String jsonSceneArgsList = System.getenv("jsonSceneArgsList");
            if (StringUtils.isNULLStr(jsonSceneArgsList)) {
                return false;
            }
            JSONObject jsonScenes = new JSONObject(jsonSceneArgsList);
            String scene = jsonScenes.getStringOrDefault("toolDescription", "");
            return "ComputeNodePrepare".equals(scene) || "UpgradePrepare".equals(scene);
        }
        catch (JSONException e) {
            log.error("Failed to obtain tool scene.", (Throwable)e);
            return false;
        }
    }

    public static boolean isComputeUpgradeScene() {
        try {
            String jsonSceneArgsList = System.getenv("jsonSceneArgsList");
            if (StringUtils.isNULLStr(jsonSceneArgsList)) {
                return false;
            }
            JSONObject jsonScenes = new JSONObject(jsonSceneArgsList);
            String scene = jsonScenes.getStringOrDefault("toolDescription", "");
            return "ComputeNodePrepare".equals(scene);
        }
        catch (JSONException e) {
            log.error("Failed to obtain tool scene.", (Throwable)e);
            return false;
        }
    }
}

