/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import com.huawei.ism.tool.devicecenter.enums.ParseXlsCheckType;
import com.huawei.ism.tool.devicecenter.exception.ExcelParseException;
import com.huawei.ism.tool.devicecenter.utils.ExcelUtils;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.util.NetUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;

public class ServerParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ServerParser.class);
    private static final String SHEET_DEV_OLD_NAME = "Sheet1";
    private static final String SHEET_DEV_NEW_NAME_ZH = "\u8bbe\u5907\u4fe1\u606f";
    private static final String SHEET_DEV_NEW_NAME = "device info";
    private static final String SHEET_NODE_NAME_ZN = "HMM\u8ba1\u7b97\u8282\u70b9\u4fe1\u606f";
    private static final String SHEET_NODE_NAME = "HMM compute node information";
    private static final Map<String, ExcelPair> COL_MAP_NEW = new HashMap<String, ExcelPair>();
    private static final String COLNUM_NODE_START_IP = "A";
    private static final String COLNUM_NODE_END_IP = "B";
    private static final String COLNUM_NODE_SLOT = "C";
    private static final String COLNUM_NODE_USER_NAME = "D";
    private static final String COLNUM_NODE_PASSWORD = "E";
    private static final String COLNUM_NODE_SNMP_PASSWORD = "F";
    private static final String COLNUM_NODE_PORT_SSH = "G";
    private static final String COLNUM_NODE_PORT_HTTPS = "H";
    private static final String COLNUM_NODE_PORT_SNMP = "I";
    private static final String COLNUM_NODE_PORT_IPMI = "J";
    private static final int SWITCH_PLATE_INFO = 8;
    private static final int COL_NUM_NODE_START_IP = 0;
    private static final int COL_NUM_NODE_END_IP = 1;
    private static final int COL_NUM_NODE_SLOT = 2;
    private static final int COL_NUM_NODE_USERNAME = 3;
    private static final int COL_NUM_NODE_USERPWD = 4;
    private static final int COL_NUM_NODE_SNMP_PWD = 5;
    private static final int COL_NUM_NODE_PORT_SSH = 6;
    private static final int COL_NUM_NODE_PORT_HTTPS = 7;
    private static final int COL_NUM_NODE_PORT_SNMP = 8;
    private static final int COL_NUM_NODE_PORT_IPMI = 9;
    private static final String STR_SEPARATE = ":";
    private static final String STR_COMMA_SEPARATE = ".";
    private static final String STR_ZERO = "0";
    private static final int DEFAULT_EXCEL_COLNUM = 48;
    private List<String> titlesImport;
    private List<String> nodeTitlesImport;
    private List<String> zhExcelConfigTitls;
    private List<String> enExcelConfigTitls;
    private List<String> devIps;
    private List<String> nodeIps;
    private List<String> keyByHttpsPort;
    private boolean isNodePortProxy;
    private int snmpNodePort;
    private boolean isOldModel;
    private boolean isNewEnglishModel;
    private int sshNodePort;
    private int ipmiNodePort;
    private int vmmNodePort;
    private String httpsPort;
    private Boolean isPortProxy;
    private int nodeRowNum;
    private Sheet nodeFileSheet;
    private File parseFile;
    private boolean useNodeSheet;

    public Boolean getPortProxy() {
        return this.isPortProxy;
    }

    public void setPortProxy(Boolean portProxy) {
        this.isPortProxy = portProxy;
    }

    public ServerParser(File file) throws ExcelParseException {
        COL_MAP_NEW.put("StartIPAddress", new ExcelPair(0, COLNUM_NODE_START_IP));
        COL_MAP_NEW.put("EndIPAddress", new ExcelPair(1, COLNUM_NODE_END_IP));
        COL_MAP_NEW.put("UserName", new ExcelPair(2, COLNUM_NODE_SLOT));
        COL_MAP_NEW.put("UserPassword", new ExcelPair(3, COLNUM_NODE_USER_NAME));
        COL_MAP_NEW.put("SnmpV3PrivPassword", new ExcelPair(4, COLNUM_NODE_PASSWORD));
        COL_MAP_NEW.put("RootPassword", new ExcelPair(5, COLNUM_NODE_SNMP_PASSWORD));
        COL_MAP_NEW.put("redfishUserName", new ExcelPair(6, COLNUM_NODE_PORT_SSH));
        COL_MAP_NEW.put("redfishPwd", new ExcelPair(7, COLNUM_NODE_PORT_HTTPS));
        COL_MAP_NEW.put("SNMPPort", new ExcelPair(8, COLNUM_NODE_PORT_SNMP));
        COL_MAP_NEW.put("SSHPort", new ExcelPair(9, COLNUM_NODE_PORT_IPMI));
        COL_MAP_NEW.put("IPMIPort", new ExcelPair(10, "K"));
        COL_MAP_NEW.put("VMMPort", new ExcelPair(11, "L"));
        COL_MAP_NEW.put("httpsPort", new ExcelPair(12, "M"));
        COL_MAP_NEW.put("Swi1_Fabric_UserName", new ExcelPair(13));
        COL_MAP_NEW.put("Swi1_Fabric_Password", new ExcelPair(14));
        COL_MAP_NEW.put("Swi1_Base_UserName", new ExcelPair(15));
        COL_MAP_NEW.put("Swi1_Base_Password", new ExcelPair(16));
        COL_MAP_NEW.put("Swi1_FC_UserName", new ExcelPair(17));
        COL_MAP_NEW.put("Swi1_FC_Password", new ExcelPair(18));
        COL_MAP_NEW.put("Swi1_BMC_UserName", new ExcelPair(19));
        COL_MAP_NEW.put("Swi1_BMC_Password", new ExcelPair(20));
        COL_MAP_NEW.put("hwDevTitleOnlySecurity", new ExcelPair(45, "AT"));
        COL_MAP_NEW.put("isPortProxy", new ExcelPair(46, "AU"));
        COL_MAP_NEW.put("isSupportAccountDecoupling", new ExcelPair(47, "AV"));
        this.titlesImport = new ArrayList<String>();
        this.nodeTitlesImport = new ArrayList<String>();
        this.zhExcelConfigTitls = new ArrayList<String>();
        this.enExcelConfigTitls = new ArrayList<String>();
        this.devIps = new ArrayList<String>();
        this.nodeIps = new ArrayList<String>();
        this.keyByHttpsPort = new ArrayList<String>();
        this.isNodePortProxy = false;
        this.isOldModel = false;
        this.isNewEnglishModel = false;
        this.sshNodePort = 0;
        this.ipmiNodePort = 0;
        this.isPortProxy = false;
        this.nodeRowNum = 0;
        this.nodeFileSheet = null;
        this.parseFile = file;
        this.initColNameNums();
    }

    private void initExcelTitles() {
        for (int i = 0; i < 48; ++i) {
            this.zhExcelConfigTitls.add(ResourceUtil.getString((String)("devicecenter.dev.import.excel.title" + i), (Locale)Locale.CHINESE));
            this.enExcelConfigTitls.add(ResourceUtil.getString((String)("devicecenter.dev.import.excel.title" + i), (Locale)Locale.ENGLISH));
        }
    }

    private boolean checkExcelModel() {
        this.initExcelTitles();
        if (this.titlesImport.size() != 48) {
            return false;
        }
        return this.checkZhFormat() || this.checkEnFormat();
    }

    private boolean checkZhFormat() {
        for (int i = 0; i < this.zhExcelConfigTitls.size(); ++i) {
            if (this.zhExcelConfigTitls.get(i).equalsIgnoreCase(this.titlesImport.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkEnFormat() {
        for (int i = 0; i < this.enExcelConfigTitls.size(); ++i) {
            if (this.enExcelConfigTitls.get(i).equalsIgnoreCase(this.titlesImport.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<AbstractDevice> parseServerByExcel() throws ExcelParseException {
        LOGGER.info("begin parse HwServer by Excel.");
        ArrayList<AbstractDevice> serverDevList = new ArrayList<AbstractDevice>();
        Workbook workBook = ExcelUtils.getWorkBook(this.parseFile);
        if (null != workBook && !this.isOldModel) {
            if (this.isCsvInjection(workBook)) {
                throw new ExcelParseException("device.import.check.csv.tips", new Object[0]);
            }
            if (!this.isNewEnglishModel) {
                return this.transformNewModel(serverDevList, workBook, SHEET_DEV_NEW_NAME_ZH, SHEET_NODE_NAME_ZN);
            }
            return this.transformNewModel(serverDevList, workBook, SHEET_DEV_NEW_NAME, SHEET_NODE_NAME);
        }
        return serverDevList;
    }

    private boolean isCsvInjection(Workbook workBook) {
        int sheetNum = workBook.getNumberOfSheets();
        for (int sheetIdx = 0; sheetIdx < sheetNum; ++sheetIdx) {
            Sheet sheet = workBook.getSheetAt(sheetIdx);
            if (VerifyUtil.isEmpty((Object)sheet) || !this.checkSheetHasCsvInjection(sheet)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSheetHasCsvInjection(Sheet sheet) {
        int rowNum = sheet.getPhysicalNumberOfRows();
        for (int rowIdx = 0; rowIdx < rowNum; ++rowIdx) {
            Row row = sheet.getRow(rowIdx);
            if (VerifyUtil.isEmpty((Object)row) || !this.checkRowHasCsvInjection(row)) continue;
            return true;
        }
        return false;
    }

    private boolean checkRowHasCsvInjection(Row row) {
        int cellNum = row.getPhysicalNumberOfCells();
        for (int cellIdx = 0; cellIdx < cellNum; ++cellIdx) {
            Cell cell = row.getCell(cellIdx);
            if (VerifyUtil.isEmpty((Object)cell) || !CellType.FORMULA.equals((Object)cell.getCellType())) continue;
            return true;
        }
        return false;
    }

    private List<AbstractDevice> transformNewModel(List<AbstractDevice> serverDevList, Workbook workBook, String devName, String nodeName) throws ExcelParseException {
        Sheet devFileSheet = workBook.getSheet(devName);
        this.nodeFileSheet = workBook.getSheet(nodeName);
        int rowNum = 0;
        rowNum = devFileSheet.getPhysicalNumberOfRows();
        if (rowNum <= 1) {
            throw new ExcelParseException(0, "", ParseXlsCheckType.NO_DEVDATA);
        }
        if (!this.checkExcelModel()) {
            throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
        }
        if (null != this.nodeFileSheet) {
            this.nodeRowNum = this.nodeFileSheet.getPhysicalNumberOfRows();
        }
        if (this.nodeRowNum > 2) {
            this.useNodeSheet = true;
        }
        if (this.useNodeSheet) {
            int r;
            this.getDeviceSheetIps(devFileSheet, rowNum);
            for (r = 2; r < this.nodeRowNum; ++r) {
                Row row = this.nodeFileSheet.getRow(r);
                int count = 0;
                count = this.getNullCount(row, count, 0);
                count = this.getNullCount(row, count, 1);
                count = this.getNullCount(row, count, 3);
                if ((count = this.getNullCount(row, count, 4)) == 4) continue;
                this.getDeviceIps(nodeName, r, row, this.nodeIps);
            }
            this.checkDevipsContainsNodeips(this.devIps, this.nodeIps);
            for (r = 1; r < rowNum; ++r) {
                this.setNewModelHwDevice(devFileSheet, r, serverDevList);
            }
        } else {
            for (int r = 1; r < rowNum; ++r) {
                HwServerDevice dev = new HwServerDevice();
                this.setHwDevice(devFileSheet, r, dev, serverDevList, COL_MAP_NEW);
                dev.setBatchImport(true);
            }
        }
        LOGGER.info("parse HwServer by Excel success.");
        return serverDevList;
    }

    private void getDeviceSheetIps(Sheet devFileSheet, int rowNum) throws ExcelParseException {
        for (int r = 1; r < rowNum; ++r) {
            Row row = devFileSheet.getRow(r);
            if (row == null) {
                throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
            }
            int count = 0;
            for (int j = 0; j < 11; ++j) {
                if (j == 4 || j == 5) continue;
                count = this.getNullCount(row, count, j);
            }
            if (count == 9) continue;
            this.getDeviceIps(devFileSheet.getSheetName(), r, row, this.devIps);
            this.setKeyByHttpsPort(devFileSheet.getSheetName(), r, row, this.keyByHttpsPort);
        }
    }

    private void getDeviceIps(String sheet, int i, Row row, List<String> ips) throws ExcelParseException {
        String startIP = ExcelUtils.getCellStrVal(row, 0);
        String endIP = ExcelUtils.getCellStrVal(row, 1);
        this.checkIPisRight(sheet, i, startIP, endIP, COL_MAP_NEW);
        if (this.isNodePortProxy) {
            ips.add(startIP.split(STR_SEPARATE)[1]);
            return;
        }
        this.checkIpv4(sheet, i, startIP, endIP);
        this.checkIpv6(i, startIP, endIP);
        if (LayUtil.checkIpV4HasSpecial(startIP)) {
            this.addIpv4(startIP, endIP, ips);
        }
        if (NetUtil.isValidIPV6((String)startIP)) {
            this.addIpv6(startIP, endIP, ips);
        }
    }

    private void setKeyByHttpsPort(String sheet, int i, Row row, List<String> keys) throws ExcelParseException {
        String httpsPortTemp = ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("httpsPort").colNumber);
        String isPortProxyTemp = ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("isPortProxy").colNumber);
        this.checkProxy(sheet, row, i);
        if (isPortProxyTemp.equals(ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.field.isproxy"))) {
            keys.add(httpsPortTemp);
        }
    }

    private void addIpv6(String startIP, String endIP, List<String> ips) {
        if (startIP.trim().equalsIgnoreCase(endIP.trim())) {
            String commonStr = startIP.substring(0, startIP.lastIndexOf(STR_SEPARATE) + 1);
            String start = startIP.substring(startIP.lastIndexOf(STR_SEPARATE) + 1).toLowerCase(Locale.ENGLISH);
            String ip = commonStr + start;
            ips.add(ip);
        } else {
            try {
                String commonStr = startIP.substring(0, startIP.lastIndexOf(STR_SEPARATE) + 1);
                String start = startIP.substring(startIP.lastIndexOf(STR_SEPARATE) + 1);
                String end = endIP.substring(endIP.lastIndexOf(STR_SEPARATE) + 1);
                if (StringUtils.isNULLStr((String)start)) {
                    start = STR_ZERO;
                }
                int startInt = Integer.parseInt(start, 16);
                int endInt = Integer.parseInt(end, 16);
                for (int j = startInt; j <= endInt; ++j) {
                    String ip = commonStr + Integer.toHexString(j);
                    ips.add(ip);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("string parse to integer error");
            }
        }
    }

    private void addIpv4(String startIp, String endIp, List<String> ips) {
        if (startIp.trim().equalsIgnoreCase(endIp.trim())) {
            ips.add(startIp);
        } else {
            int i;
            String[] startIpArr = startIp.split("\\.");
            String[] endIpArr = endIp.split("\\.");
            if (startIpArr.length != 4 || endIpArr.length != 4) {
                return;
            }
            int start3Ip = Integer.valueOf(startIpArr[2]);
            int start4Ip = Integer.valueOf(startIpArr[3]);
            int end3Ip = Integer.valueOf(endIpArr[2]);
            int end4Ip = Integer.valueOf(endIpArr[3]);
            if (start3Ip == end3Ip) {
                for (int i2 = start4Ip; i2 <= end4Ip; ++i2) {
                    ips.add(ServerParser.buildIp(startIpArr[0], startIpArr[1], startIpArr[2], String.valueOf(i2)));
                }
                return;
            }
            int ip3Min = Math.min(start3Ip, end3Ip);
            for (int i3 = start4Ip; i3 < 256; ++i3) {
                ips.add(ServerParser.buildIp(startIpArr[0], startIpArr[1], String.valueOf(ip3Min), String.valueOf(i3)));
            }
            int ip3Max = Math.max(start3Ip, end3Ip);
            for (i = ip3Min + 1; i < ip3Max; ++i) {
                for (int j = 0; j < 256; ++j) {
                    ips.add(ServerParser.buildIp(startIpArr[0], startIpArr[1], String.valueOf(i), String.valueOf(j)));
                }
            }
            for (i = 0; i <= end4Ip; ++i) {
                ips.add(ServerParser.buildIp(startIpArr[0], startIpArr[1], String.valueOf(ip3Max), String.valueOf(i)));
            }
        }
    }

    private static String buildIp(String ... ips) {
        return String.join((CharSequence)STR_COMMA_SEPARATE, ips);
    }

    private void checkIpv6(int i, String startIP, String endIP) throws ExcelParseException {
        if (NetUtil.isValidIPV6((String)startIP)) {
            if (NetUtil.isValidIPV4((String)endIP)) {
                throw new ExcelParseException(i + 1, "", ParseXlsCheckType.START_FORMAT_EQUAL_END);
            }
            if (!LayUtil.isIpv6StartIpLessEnd(startIP, endIP)) {
                throw new ExcelParseException(i + 1, "", ParseXlsCheckType.START_BIGGER_THAN_END);
            }
        }
    }

    private void checkIpv4(String sheet, int i, String startIP, String endIP) throws ExcelParseException {
        if (LayUtil.checkIpV4HasSpecial(startIP)) {
            if (NetUtil.isValidIPV6((String)endIP)) {
                throw new ExcelParseException(i + 1, "", ParseXlsCheckType.START_FORMAT_EQUAL_END);
            }
            if (!LayUtil.isStartIpLessEnd(startIP, endIP)) {
                throw new ExcelParseException(i + 1, "", ParseXlsCheckType.START_BIGGER_THAN_END);
            }
            if (!SmartkitUtils.checkIpBefore2NetPart(startIP, endIP)) {
                throw new ExcelParseException(i + 1, COL_MAP_NEW.get("StartIPAddress").getColLabel() + "," + COL_MAP_NEW.get("EndIPAddress").getColLabel(), ParseXlsCheckType.STARTENDIP_NOT_LEGAL, sheet);
            }
        }
    }

    private void checkDevipsContainsNodeips(List<String> devIps, List<String> nodeIps) throws ExcelParseException {
        int nodeLength = nodeIps.size();
        for (int i = 0; i < nodeLength; ++i) {
            if (devIps.contains(nodeIps.get(i)) || this.keyByHttpsPort.contains(nodeIps.get(i))) continue;
            throw new ExcelParseException(0, "", ParseXlsCheckType.HMMNODE_NOT_CONTAIN_IN_DEV);
        }
    }

    private void setNewModelHwDevice(Sheet devSheet, int i, List<AbstractDevice> serverDevList) throws ExcelParseException {
        Row row = null;
        if (null != devSheet) {
            row = devSheet.getRow(i);
        }
        if (null == row) {
            throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
        }
        int count = 0;
        for (int j = 0; j < 11; ++j) {
            if (j == 4 || j == 5) continue;
            count = this.getNullCount(row, count, j);
        }
        if ((count = this.getNullCount(row, count, 45)) == 10) {
            return;
        }
        this.setNewModelValue(devSheet.getSheetName(), i, row, serverDevList);
    }

    private void setHwDevice(Sheet devSheet, int rowNum, HwServerDevice dev, List<AbstractDevice> serverDevList, Map<String, ExcelPair> colMap) throws ExcelParseException {
        Row row = null;
        if (null != devSheet) {
            row = devSheet.getRow(rowNum);
        }
        if (null == row) {
            throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
        }
        int count = 0;
        for (int j = 0; j < 12; ++j) {
            if (j == 4 || j == 5 || j == 6) continue;
            count = this.getNullCount(row, count, j);
        }
        if (count <= 9) {
            return;
        }
        this.setValue(devSheet.getSheetName(), rowNum, dev, row, colMap);
        this.setSwitchPlateInfo(dev, row, colMap);
        serverDevList.add(dev);
    }

    private int getNullCount(Row r, int count, int j) {
        int tmp = count;
        try {
            Cell cell = r.getCell(j);
            if (null == cell) {
                ++tmp;
            } else {
                cell.setCellType(CellType.STRING);
                if (StringUtils.isNULLStr((String)cell.getStringCellValue())) {
                    ++tmp;
                }
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Getting cell errors" + e);
        }
        return tmp;
    }

    private void setNewModelValue(String sheet, int i, Row row, List<AbstractDevice> serverDevList) throws ExcelParseException {
        String isSupportAccountSeparation = ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("isSupportAccountDecoupling").getColNumber());
        String pwd = ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("UserPassword").getColNumber());
        String userName = ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("UserName").getColNumber());
        this.checkUserNameAndPwd(sheet, i, userName, pwd, true);
        ArrayList<String> deviceRowIps = new ArrayList<String>();
        this.getDeviceIps(sheet, i, row, deviceRowIps);
        this.checkSSHAndSNMPPort(sheet, row, i);
        this.checkIPMIAndVMMPort(sheet, row, i);
        this.checkAndSetRedPort(sheet, row, i);
        this.checkOnlySecurityAlgSupported(sheet, row, i);
        this.checkProxy(sheet, row, i);
        boolean shouldSupportAccountSeparation = isSupportAccountSeparation.trim().equalsIgnoreCase(ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.field.isproxy"));
        for (int j = 0; j < deviceRowIps.size(); ++j) {
            String ip = (String)deviceRowIps.get(j);
            HwServerDevice dev = new HwServerDevice();
            dev.setStartIPAddress(ip);
            dev.setEndIPAddress(ip);
            dev.setUserName(userName);
            dev.setUserPwd(pwd);
            dev.setSnmpPrivPwd(ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("SnmpV3PrivPassword").getColNumber()));
            dev.setRootPwd(ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("RootPassword").getColNumber()));
            dev.setSshPort(this.sshNodePort);
            dev.setSnmpPort(this.snmpNodePort);
            dev.setIpmiPort(this.ipmiNodePort);
            dev.setVmmPort(this.vmmNodePort);
            dev.setRedFishPort(this.httpsPort);
            dev.setPortProxy(this.isPortProxy);
            dev.setBatchImport(true);
            dev.setOnlySecurityAlgSupportedFlag(this.isOnlySecurityAlgSupported(row));
            if (shouldSupportAccountSeparation) {
                this.redfishNullCheck(row, sheet, i);
            }
            dev.setRedFishUserName(ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("redfishUserName").getColNumber()));
            dev.setRedFishPwd(ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("redfishPwd").getColNumber()));
            dev.setSupportAccountSeparation(shouldSupportAccountSeparation);
            this.setSwitchPlateInfo(dev, row, COL_MAP_NEW);
            this.addComputeNodeInfo(i, serverDevList, ip, dev, this.httpsPort);
        }
    }

    private boolean isOnlySecurityAlgSupported(Row row) throws ExcelParseException {
        String compatibilityAlgorithmValue = ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("hwDevTitleOnlySecurity").getColNumber()).trim();
        return !this.isSelectYes(compatibilityAlgorithmValue);
    }

    private boolean isSelectYes(String value) {
        return ResourceUtil.getString((String)"devicecenter.device.import.enabling.compatibility.algorithm.yes", (Locale)Locale.ENGLISH).equalsIgnoreCase(value) || ResourceUtil.getString((String)"devicecenter.device.import.enabling.compatibility.algorithm.yes", (Locale)Locale.CHINESE).equalsIgnoreCase(value);
    }

    private void redfishNullCheck(Row row, String sheet, int rowNum) throws ExcelParseException {
        if (VerifyUtil.isEmpty((String)ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("redfishUserName").getColNumber()))) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("redfishUserName").getColLabel(), "redfishUserName", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (VerifyUtil.isEmpty((String)ExcelUtils.getCellStrVal(row, COL_MAP_NEW.get("redfishPwd").getColNumber()))) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("redfishPwd").getColLabel(), "redfishPwd", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
    }

    private void addComputeNodeInfo(int i, List<AbstractDevice> serverDevList, String ip, HwServerDevice dev, String keyHttpSport) throws ExcelParseException {
        String sheet = SHEET_NODE_NAME_ZN;
        if (this.isEngliseEnv()) {
            sheet = SHEET_NODE_NAME;
        }
        for (int j = 2; j < this.nodeRowNum; ++j) {
            Row nodeRow = this.nodeFileSheet.getRow(j);
            int count = 0;
            count = this.getNullCount(nodeRow, count, 0);
            count = this.getNullCount(nodeRow, count, 1);
            count = this.getNullCount(nodeRow, count, 3);
            if ((count = this.getNullCount(nodeRow, count, 4)) == 4) continue;
            String nodeUserName = ExcelUtils.getCellStrVal(nodeRow, 3);
            String nodeUserPwd = ExcelUtils.getCellStrVal(nodeRow, 4);
            this.checkUserNameAndPwd(sheet, j, nodeUserName, nodeUserPwd, false);
            String nodeSlot = ExcelUtils.getCellStrVal(nodeRow, 2);
            this.checkNodeSlot(nodeSlot, j);
            String nodeSnmpPwd = ExcelUtils.getCellStrVal(nodeRow, 5);
            String nodeSshPort = ExcelUtils.getCellStrVal(nodeRow, 6);
            String nodeHttpsPort = ExcelUtils.getCellStrVal(nodeRow, 7);
            String nodeSnmpPort = ExcelUtils.getCellStrVal(nodeRow, 8);
            String nodeIpmiPort = ExcelUtils.getCellStrVal(nodeRow, 9);
            this.checkNodePort(nodeSshPort, COLNUM_NODE_PORT_SSH, j);
            this.checkNodePort(nodeHttpsPort, COLNUM_NODE_PORT_HTTPS, j);
            this.checkNodePort(nodeSnmpPort, COLNUM_NODE_PORT_SNMP, j);
            this.checkNodePort(nodeIpmiPort, COLNUM_NODE_PORT_IPMI, j);
            ArrayList<String> nodeRowIps = new ArrayList<String>();
            this.getDeviceIps(sheet, j, nodeRow, nodeRowIps);
            for (int k = 0; k < nodeRowIps.size(); ++k) {
                if (!((String)nodeRowIps.get(k)).equalsIgnoreCase(ip) && (!dev.isPortProxy() || !((String)nodeRowIps.get(k)).equals(keyHttpSport))) continue;
                ComputeNodePlate computeNodePlate = new ComputeNodePlate();
                computeNodePlate.setSlotId(nodeSlot);
                computeNodePlate.setSlotUser(nodeUserName);
                computeNodePlate.setSlotPasswd(nodeUserPwd);
                computeNodePlate.setSlotSnmpPrivPwd(nodeSnmpPwd);
                computeNodePlate.setSlotSSHPort(nodeSshPort);
                computeNodePlate.setSlotHttpsPort(nodeHttpsPort);
                computeNodePlate.setSlotSNMPPort(nodeSnmpPort);
                computeNodePlate.setSlotIPMIPort(nodeIpmiPort);
                dev.getComputeNodePlateList().add(computeNodePlate);
            }
        }
        serverDevList.add(dev);
    }

    public boolean isEngliseEnv() {
        return LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH);
    }

    private void checkNodeSlot(String nodeSlot, int i) throws ExcelParseException {
        try {
            int slot = Integer.valueOf(nodeSlot);
            if (slot <= 0 || slot > 32) {
                throw new ExcelParseException(i + 1, COLNUM_NODE_SLOT, ParseXlsCheckType.NODE_SLOT_ERROR);
            }
        }
        catch (RuntimeException e) {
            throw new ExcelParseException(i + 1, COLNUM_NODE_SLOT, ParseXlsCheckType.NODE_SLOT_ERROR);
        }
    }

    private void checkNodePort(String port, String colNum, int rowNum) throws ExcelParseException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)port.trim())) {
            throw new ExcelParseException(rowNum + 1, colNum, ParseXlsCheckType.NODE_CAN_NOTNULL);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)port)) {
            throw new ExcelParseException(rowNum + 1, colNum, ParseXlsCheckType.NODE_PORT_NOTNUM);
        }
        int sshPortNum = Integer.valueOf(port);
        if (!SmartkitUtils.isPortLegal(sshPortNum)) {
            throw new ExcelParseException(rowNum + 1, colNum, ParseXlsCheckType.NODE_PORT_ERROR);
        }
    }

    private void checkUserNameAndPwd(String sheet, int i, String userName, String pwd, boolean flag) throws ExcelParseException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)userName.trim())) {
            if (flag) {
                throw new ExcelParseException(i + 1, COL_MAP_NEW.get("UserName").getColLabel(), "UserName", ParseXlsCheckType.CAN_NOTNULL, sheet);
            }
            throw new ExcelParseException(i + 1, COLNUM_NODE_USER_NAME, "UserName", ParseXlsCheckType.NODE_CAN_NOTNULL, sheet);
        }
        if ("".equals(pwd)) {
            if (flag) {
                throw new ExcelParseException(i + 1, COL_MAP_NEW.get("UserPassword").getColLabel(), "UserPassword", ParseXlsCheckType.CAN_NOTNULL, sheet);
            }
            throw new ExcelParseException(i + 1, COLNUM_NODE_PASSWORD, "UserPassword", ParseXlsCheckType.NODE_CAN_NOTNULL, sheet);
        }
    }

    private void setValue(String sheet, int rowNum, HwServerDevice serverDev, Row row, Map<String, ExcelPair> colMap) throws ExcelParseException {
        String startIP = ExcelUtils.getCellStrVal(row, colMap.get("StartIPAddress").getColNumber());
        String endIP = ExcelUtils.getCellStrVal(row, colMap.get("EndIPAddress").getColNumber());
        this.checkIPisRight(sheet, rowNum, startIP, endIP, colMap);
        this.checkIpv4(sheet, rowNum, startIP, endIP);
        this.checkIpv6(rowNum, startIP, endIP);
        serverDev.setStartIPAddress(startIP);
        serverDev.setEndIPAddress(endIP);
        String userName = ExcelUtils.getCellStrVal(row, colMap.get("UserName").getColNumber());
        String pwd = ExcelUtils.getCellStrVal(row, colMap.get("UserPassword").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)userName.trim())) {
            throw new ExcelParseException(rowNum + 1, colMap.get("UserName").getColLabel(), "UserName", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if ("".equals(pwd)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("UserPassword").getColLabel(), "UserPassword", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        serverDev.setUserName(userName);
        serverDev.setUserPwd(pwd);
        serverDev.setSnmpPrivPwd(ExcelUtils.getCellStrVal(row, colMap.get("SnmpV3PrivPassword").getColNumber()));
        serverDev.setRootPwd(ExcelUtils.getCellStrVal(row, colMap.get("RootPassword").getColNumber()));
        this.checkAndSetDevSSHAndSNMPPort(sheet, serverDev, row, rowNum, colMap);
        this.checkAndSetDevIPMIAndsVMMPort(sheet, serverDev, row, rowNum, colMap);
        this.checkAndSetPort2(sheet, serverDev, row, rowNum, colMap);
        serverDev.setOnlySecurityAlgSupportedFlag(this.isOnlySecurityAlgSupported(row));
        serverDev.setRedFishUserName(ExcelUtils.getCellStrVal(row, colMap.get("redfishUserName").getColNumber()));
        serverDev.setRedFishPwd(ExcelUtils.getCellStrVal(row, colMap.get("redfishPwd").getColNumber()));
        String supportAccountSeparationValue = ExcelUtils.getCellStrVal(row, colMap.get("isSupportAccountDecoupling").getColNumber());
        serverDev.setSupportAccountSeparation(supportAccountSeparationValue.trim().equalsIgnoreCase(ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.field.isproxy")));
    }

    private void checkIPisRight(String sheetName, int i, String startIP, String endIP, Map<String, ExcelPair> colMap) throws ExcelParseException {
        String[] split;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startIP.trim())) {
            throw new ExcelParseException(i + 1, colMap.get("StartIPAddress").getColLabel(), "StartIPAddress", ParseXlsCheckType.CAN_NOTNULL, sheetName);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endIP.trim())) {
            throw new ExcelParseException(i + 1, colMap.get("EndIPAddress").getColLabel(), "EndIPAddress", ParseXlsCheckType.CAN_NOTNULL, sheetName);
        }
        if (startIP.equals(endIP) && startIP.contains(STR_SEPARATE) && (split = startIP.split(STR_SEPARATE)).length == 2) {
            this.checkIPisRight(sheetName, i, split[0], split[0], colMap);
            this.checkNodePort(split[1], colMap.get("StartIPAddress").getColLabel(), i);
            this.isNodePortProxy = true;
            return;
        }
        this.isNodePortProxy = false;
        if (!LayUtil.checkIpForServer(startIP) || !LayUtil.checkIpForServer(endIP)) {
            throw new ExcelParseException(i + 1, colMap.get("StartIPAddress").getColLabel() + "," + colMap.get("EndIPAddress").getColLabel(), "StartIPAddress", ParseXlsCheckType.IP_NOT_LEGAL, sheetName);
        }
    }

    private void setSwitchPlateInfo(HwServerDevice serverDev, Row row, Map<String, ExcelPair> colMap) throws ExcelParseException {
        for (int swId = 1; swId <= 4; ++swId) {
            SwitchPlate swPlate = new SwitchPlate();
            int swiFabricUserNameIdx = colMap.get("Swi1_Fabric_UserName").getColNumber() + (swId - 1) * 8;
            int swiFabricPasswordIdx = colMap.get("Swi1_Fabric_Password").getColNumber() + (swId - 1) * 8;
            int swiFcUserNameIdx = colMap.get("Swi1_FC_UserName").getColNumber() + (swId - 1) * 8;
            int swiFcPasswordIdx = colMap.get("Swi1_FC_Password").getColNumber() + (swId - 1) * 8;
            int swiBaseUserNameIdx = colMap.get("Swi1_Base_UserName").getColNumber() + (swId - 1) * 8;
            int swiBasePasswordIdx = colMap.get("Swi1_Base_Password").getColNumber() + (swId - 1) * 8;
            int swiBmcUserNameIdx = colMap.get("Swi1_BMC_UserName").getColNumber() + (swId - 1) * 8;
            int swiBmcPwdIdx = colMap.get("Swi1_BMC_Password").getColNumber() + (swId - 1) * 8;
            swPlate.setFabricUserName(ExcelUtils.getCellStrVal(row, swiFabricUserNameIdx));
            swPlate.setFabricPwd(ExcelUtils.getCellStrVal(row, swiFabricPasswordIdx));
            swPlate.setFcUserName(ExcelUtils.getCellStrVal(row, swiFcUserNameIdx));
            swPlate.setFcPwd(ExcelUtils.getCellStrVal(row, swiFcPasswordIdx));
            swPlate.setBaseUserName(ExcelUtils.getCellStrVal(row, swiBaseUserNameIdx));
            swPlate.setBasePwd(ExcelUtils.getCellStrVal(row, swiBasePasswordIdx));
            swPlate.setBmcUserName(ExcelUtils.getCellStrVal(row, swiBmcUserNameIdx));
            swPlate.setBmcPwd(ExcelUtils.getCellStrVal(row, swiBmcPwdIdx));
            if (swPlate.isSwitchPlateEmpty()) continue;
            serverDev.getSwitchPlateMap().put("switch_plate" + swId, swPlate);
        }
    }

    private void checkAndSetDevSSHAndSNMPPort(String sheet, HwServerDevice server, Row dataRow, int rowNum, Map<String, ExcelPair> colMap) throws ExcelParseException {
        String snmp = ExcelUtils.getCellStrVal(dataRow, colMap.get("SNMPPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)snmp.trim())) {
            throw new ExcelParseException(rowNum + 1, colMap.get("SNMPPort").getColLabel(), "SNMPPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)snmp)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("SNMPPort").getColLabel(), "SNMPPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        int snmpPort = Integer.valueOf(snmp);
        if (!SmartkitUtils.isPortLegal(snmpPort)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("SNMPPort").getColLabel(), "SNMPPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        server.setSnmpPort(snmpPort);
        String ssh = ExcelUtils.getCellStrVal(dataRow, colMap.get("SSHPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ssh.trim())) {
            throw new ExcelParseException(rowNum + 1, colMap.get("SSHPort").getColLabel(), "SSHPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)ssh)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("SSHPort").getColLabel(), "SSHPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        int sshPort = Integer.valueOf(ssh);
        if (!SmartkitUtils.isPortLegal(sshPort)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("SSHPort").getColLabel(), "SSHPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        server.setSshPort(sshPort);
    }

    private void checkAndSetDevIPMIAndsVMMPort(String sheet, HwServerDevice server, Row dataRow, int rowNum, Map<String, ExcelPair> colMap) throws ExcelParseException {
        String ipmi = ExcelUtils.getCellStrVal(dataRow, colMap.get("IPMIPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ipmi.trim())) {
            throw new ExcelParseException(rowNum + 1, colMap.get("IPMIPort").getColLabel(), "IPMIPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)ipmi)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("IPMIPort").getColLabel(), "IPMIPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        int immiPort = Integer.valueOf(ipmi);
        if (!SmartkitUtils.isPortLegal(immiPort)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("IPMIPort").getColLabel(), "IPMIPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        server.setIpmiPort(immiPort);
        String vmm = ExcelUtils.getCellStrVal(dataRow, colMap.get("VMMPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vmm.trim())) {
            throw new ExcelParseException(rowNum + 1, colMap.get("VMMPort").getColLabel(), "VMMPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)vmm)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("VMMPort").getColLabel(), "VMMPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        int vmmPort = Integer.valueOf(vmm);
        if (!SmartkitUtils.isPortLegal(vmmPort)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("VMMPort").getColLabel(), "VMMPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        server.setVmmPort(vmmPort);
    }

    private void checkAndSetPort2(String sheet, HwServerDevice server, Row dataRow, int rowNum, Map<String, ExcelPair> colMap) throws ExcelParseException {
        String redFishPort = ExcelUtils.getCellStrVal(dataRow, colMap.get("httpsPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)redFishPort.trim())) {
            throw new ExcelParseException(rowNum + 1, colMap.get("httpsPort").getColLabel(), "HTTPSPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)redFishPort)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("httpsPort").getColLabel(), "HTTPSPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        int redFishPortNum = Integer.valueOf(redFishPort);
        if (!SmartkitUtils.isPortLegal(redFishPortNum)) {
            throw new ExcelParseException(rowNum + 1, colMap.get("httpsPort").getColLabel(), "HTTPSPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        server.setRedFishPort(redFishPort);
    }

    private void checkSSHAndSNMPPort(String sheet, Row dataRow, int rowNum) throws ExcelParseException {
        String snmp = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("SNMPPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)snmp.trim())) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("SNMPPort").getColLabel(), "SNMPPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)snmp)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("SNMPPort").getColLabel(), "SNMPPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        this.snmpNodePort = Integer.valueOf(snmp);
        if (!SmartkitUtils.isPortLegal(this.snmpNodePort)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("SNMPPort").getColLabel(), "SNMPPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        String ssh = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("SSHPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ssh.trim())) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("SSHPort").getColLabel(), "SSHPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)ssh)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("SSHPort").getColLabel(), "SSHPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        this.sshNodePort = Integer.valueOf(ssh);
        if (!SmartkitUtils.isPortLegal(this.sshNodePort)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("SSHPort").getColLabel(), "SSHPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
    }

    private void checkProxy(String sheet, Row dataRow, int rowNum) throws ExcelParseException {
        String endIp;
        String proxy = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("isPortProxy").getColNumber());
        String startIp = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("StartIPAddress").getColNumber());
        if (!(startIp.equals(endIp = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("EndIPAddress").getColNumber())) && NetUtil.isValidIPV4((String)startIp) || !proxy.equals(ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.field.isproxy")))) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("StartIPAddress").getColLabel() + "," + COL_MAP_NEW.get("EndIPAddress").getColLabel(), ParseXlsCheckType.PROXY_STARTENDIP_NOT_SAME, sheet);
        }
        this.isPortProxy = proxy.equals(ResourceUtil.getString((String)"devicecenter.batchimport.parse.excelModel.field.isproxy")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private void checkIPMIAndVMMPort(String sheet, Row dataRow, int rowNum) throws ExcelParseException {
        String ipmi = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("IPMIPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ipmi.trim())) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("IPMIPort").getColLabel(), "IPMIPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)ipmi)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("IPMIPort").getColLabel(), "IPMIPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        this.ipmiNodePort = Integer.valueOf(ipmi);
        if (!SmartkitUtils.isPortLegal(this.ipmiNodePort)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("IPMIPort").getColLabel(), "IPMIPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
        String vmm = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("VMMPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vmm.trim())) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("VMMPort").getColLabel(), "VMMPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)vmm)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("VMMPort").getColLabel(), "VMMPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        this.vmmNodePort = Integer.valueOf(vmm);
        if (!SmartkitUtils.isPortLegal(this.vmmNodePort)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("VMMPort").getColLabel(), "VMMPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
    }

    private void checkAndSetRedPort(String sheet, Row dataRow, int rowNum) throws ExcelParseException {
        this.httpsPort = ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("httpsPort").getColNumber());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.httpsPort.trim())) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("httpsPort").getColLabel(), "HTTPSPort", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)this.httpsPort)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("httpsPort").getColLabel(), "HTTPSPort", ParseXlsCheckType.PORT_NOTNUM, sheet);
        }
        int redFishPortNum = Integer.valueOf(this.httpsPort);
        if (!SmartkitUtils.isPortLegal(redFishPortNum)) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("httpsPort").getColLabel(), "HTTPSPort", ParseXlsCheckType.PORT_ERROR, sheet);
        }
    }

    private void checkOnlySecurityAlgSupported(String sheet, Row dataRow, int rowNum) throws ExcelParseException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ExcelUtils.getCellStrVal(dataRow, COL_MAP_NEW.get("hwDevTitleOnlySecurity").getColNumber()))) {
            throw new ExcelParseException(rowNum + 1, COL_MAP_NEW.get("hwDevTitleOnlySecurity").getColLabel(), "hwDevTitleOnlySecurity", ParseXlsCheckType.CAN_NOTNULL, sheet);
        }
    }

    private void initColNameNums() throws ExcelParseException {
        try {
            Throwable throwable = null;
            try (Workbook workBook = ExcelUtils.getWorkBook(this.parseFile);){
                Sheet devSheet = null;
                Sheet nodeSheet = null;
                if (workBook == null) {
                    LOGGER.info("initColNameNums failed.workBook is null.");
                    throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
                }
                if (workBook.getSheet(SHEET_DEV_NEW_NAME_ZH) != null) {
                    devSheet = workBook.getSheet(SHEET_DEV_NEW_NAME_ZH);
                    nodeSheet = workBook.getSheet(SHEET_NODE_NAME_ZN);
                    this.checkSheetInfo(devSheet, 0, this.titlesImport);
                    this.checkSheetInfo(nodeSheet, 1, this.nodeTitlesImport);
                    return;
                }
                if (workBook.getSheet(SHEET_DEV_NEW_NAME) != null) {
                    devSheet = workBook.getSheet(SHEET_DEV_NEW_NAME);
                    nodeSheet = workBook.getSheet(SHEET_NODE_NAME);
                    this.checkSheetInfo(devSheet, 0, this.titlesImport);
                    this.checkSheetInfo(nodeSheet, 1, this.nodeTitlesImport);
                    this.isNewEnglishModel = true;
                    return;
                }
                try {
                    throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (Exception e) {
            throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
        }
    }

    private void checkSheetInfo(Sheet sheet, int rowNum, List<String> list) throws ExcelParseException {
        if (null != sheet) {
            Row row = sheet.getRow(rowNum);
            if (null != row) {
                int rowColNum = row.getPhysicalNumberOfCells();
                for (int i = 0; i < rowColNum; ++i) {
                    String name = "";
                    try {
                        name = ExcelUtils.getCellStrVal(row, i);
                        list.add(name);
                        continue;
                    }
                    catch (ExcelParseException e) {
                        LOGGER.error("ExcelParseException");
                    }
                }
            }
        } else {
            throw new ExcelParseException(0, "", ParseXlsCheckType.EXCEL_NOT_LEGAL);
        }
    }

    private class ExcelPair {
        private int colNumber;
        private String colLabel;

        public ExcelPair(int colNumber, String colLabel) {
            this.colNumber = colNumber;
            this.colLabel = colLabel;
        }

        public ExcelPair(int colNumber) {
            this(colNumber, "");
        }

        public int getColNumber() {
            return this.colNumber;
        }

        public void setColNumber(int colNumber) {
            this.colNumber = colNumber;
        }

        public String getColLabel() {
            return this.colLabel;
        }

        public void setColLabel(String colLabel) {
            this.colLabel = colLabel;
        }
    }
}

