/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.devicecenter.driver.model.DriverParams;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import com.huawei.ism.tool.devicecenter.utils.ExcelUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TaskXmlUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExcelUtils.class);

    public static boolean createHwServerXml(String hwServerXmlPath, DriverParams param) throws ToolException {
        File file = new File(hwServerXmlPath);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
        try {
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new ToolException("create hwServer.xml error.");
            }
        }
        catch (IOException e) {
            LOGGER.error("create hwServer.xml io error");
            return false;
        }
        Document hwServerDocument = XmlWriter.createNewDocument();
        Element taskRoot = XmlWriter.createTagElement((Document)hwServerDocument, (String)"root");
        TaskXmlUtil.devConfig(param, hwServerDocument, taskRoot);
        hwServerDocument.appendChild(taskRoot);
        XmlWriter.writeDomToXmlFile((Document)hwServerDocument, (String)hwServerXmlPath, (boolean)true);
        return true;
    }

    private static void saveElement(DriverParams param, Document hwServerDocument, Element servers, HwServerDevice hwServerDev) {
        Element startIp = XmlWriter.createTagElement((Document)hwServerDocument, (String)"StartIPAddress", (String)hwServerDev.getStartIPAddress());
        Element endIp = XmlWriter.createTagElement((Document)hwServerDocument, (String)"EndIPAddress", (String)hwServerDev.getEndIPAddress());
        Element userName = XmlWriter.createTagElement((Document)hwServerDocument, (String)"UserName", (String)hwServerDev.getUserName());
        Element userPwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)"UserPassword", (String)AESEncrypt.encrypt128((String)hwServerDev.getUserPwd()));
        Element snmpPwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)"SnmpV3PrivPassword", (String)AESEncrypt.encrypt128((String)hwServerDev.getSnmpPrivPwd()));
        Element rootPwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)"RootPassword", (String)AESEncrypt.encrypt128((String)hwServerDev.getRootPwd()));
        Element snmPort = XmlWriter.createTagElement((Document)hwServerDocument, (String)"SNMPPort", (String)String.valueOf(hwServerDev.getSnmpPort()));
        Element community = XmlWriter.createTagElement((Document)hwServerDocument, (String)"Community", (String)hwServerDev.getCommunity());
        Element ipmiPort = XmlWriter.createTagElement((Document)hwServerDocument, (String)"IPMIPort", (String)String.valueOf(hwServerDev.getIpmiPort()));
        Element sshPort = XmlWriter.createTagElement((Document)hwServerDocument, (String)"SSHPort", (String)String.valueOf(hwServerDev.getSshPort()));
        Element vmmPort = XmlWriter.createTagElement((Document)hwServerDocument, (String)"VMMPort", (String)String.valueOf(hwServerDev.getVmmPort()));
        Element redFishPort = XmlWriter.createTagElement((Document)hwServerDocument, (String)"HTTPSPort", (String)hwServerDev.getRedFishPort());
        Element portProxy = XmlWriter.createTagElement((Document)hwServerDocument, (String)"isPortProxy", (String)String.valueOf(hwServerDev.isPortProxy()));
        servers.appendChild(startIp);
        servers.appendChild(endIp);
        servers.appendChild(XmlWriter.createTagElement((Document)hwServerDocument, (String)"onlySecurityAlgorithms", (String)Boolean.toString(hwServerDev.isOnlySecurityAlgSupportedFlag())));
        servers.appendChild(userName);
        servers.appendChild(userPwd);
        servers.appendChild(snmpPwd);
        servers.appendChild(rootPwd);
        servers.appendChild(snmPort);
        servers.appendChild(community);
        servers.appendChild(ipmiPort);
        servers.appendChild(sshPort);
        servers.appendChild(vmmPort);
        servers.appendChild(redFishPort);
        servers.appendChild(portProxy);
        servers.appendChild(XmlWriter.createTagElement((Document)hwServerDocument, (String)"redfishUserName", (String)hwServerDev.getRedFishUserName()));
        servers.appendChild(XmlWriter.createTagElement((Document)hwServerDocument, (String)"redfishPwd", (String)AESEncrypt.encrypt128((String)hwServerDev.getRedFishPwd())));
        servers.appendChild(XmlWriter.createTagElement((Document)hwServerDocument, (String)"isSupportAccountDecoupling", (String)Boolean.toString(hwServerDev.isSupportAccountSeparation())));
    }

    private static void devConfig(DriverParams param, Document hwServerDocument, Element taskRoot) {
        for (AbstractDevice dev : param.getDeviceList()) {
            HwServerDevice hwServerDev = (HwServerDevice)dev;
            Element servers = XmlWriter.createTagElement((Document)hwServerDocument, (String)"Servers");
            TaskXmlUtil.saveElement(param, hwServerDocument, servers, hwServerDev);
            Map<String, SwitchPlate> switchPlateMap = hwServerDev.getSwitchPlateMap();
            TaskXmlUtil.swConfig(param, hwServerDocument, servers, switchPlateMap);
            TaskXmlUtil.writeComputeNodeInfoToXml(param, hwServerDocument, hwServerDev, servers);
            taskRoot.appendChild(servers);
        }
    }

    private static void swConfig(DriverParams param, Document hwServerDocument, Element servers, Map<String, SwitchPlate> switchPlateMap) {
        for (Map.Entry<String, SwitchPlate> entry : switchPlateMap.entrySet()) {
            Element swNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"Switch");
            String k = entry.getKey();
            k = String.valueOf(k.charAt(k.length() - 1));
            SwitchPlate swPlate = entry.getValue();
            if (null == swPlate) continue;
            Element sw1FbUserName = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_Fabric_UserName"), (String)swPlate.getFabricUserName());
            Element sw1FbPwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_Fabric_Password"), (String)AESEncrypt.encrypt128((String)swPlate.getFabricPwd()));
            Element sw1FcUserName = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_FC_UserName"), (String)swPlate.getFcUserName());
            Element sw1FcPwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_FC_Password"), (String)AESEncrypt.encrypt128((String)swPlate.getFcPwd()));
            Element sw1BaseUserName = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_Base_UserName"), (String)swPlate.getBaseUserName());
            Element sw1BasePwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_Base_Password"), (String)AESEncrypt.encrypt128((String)swPlate.getBasePwd()));
            Element sw1BmcUserName = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_BMC_UserName"), (String)swPlate.getBmcUserName());
            Element sw1BmcPwd = XmlWriter.createTagElement((Document)hwServerDocument, (String)("Swi" + k + "_BMC_Password"), (String)AESEncrypt.encrypt128((String)swPlate.getBmcPwd()));
            swNode.appendChild(sw1FbUserName);
            swNode.appendChild(sw1FbPwd);
            swNode.appendChild(sw1FcUserName);
            swNode.appendChild(sw1FcPwd);
            swNode.appendChild(sw1BaseUserName);
            swNode.appendChild(sw1BasePwd);
            swNode.appendChild(sw1BmcUserName);
            swNode.appendChild(sw1BmcPwd);
            servers.appendChild(swNode);
        }
    }

    private static void writeComputeNodeInfoToXml(DriverParams param, Document hwServerDocument, HwServerDevice hwServerDev, Element servers) {
        Element applyToOther = XmlWriter.createTagElement((Document)hwServerDocument, (String)"slotApplyToOthers", (String)String.valueOf(hwServerDev.isApplyToOtherNodes()));
        Element slotsInfosNodes = XmlWriter.createTagElement((Document)hwServerDocument, (String)"slotsInfos");
        for (ComputeNodePlate computeNodePlate : hwServerDev.getComputeNodePlateList()) {
            Element soltInfoNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"slotInfo");
            Element soltIdNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"slotId", (String)computeNodePlate.getSlotId());
            Element userNameNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"username", (String)computeNodePlate.getSlotUser());
            Element pwdNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"password", (String)AESEncrypt.encrypt128((String)computeNodePlate.getSlotPasswd()));
            Element snmpPwdNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"snmpPrivPassword", (String)AESEncrypt.encrypt128((String)computeNodePlate.getSlotSnmpPrivPwd()));
            Element sshPortNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"sshPort", (String)computeNodePlate.getSlotSSHPort());
            Element ipmiPortNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"ipmiPort", (String)computeNodePlate.getSlotIPMIPort());
            Element httpsPortNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"httpsPort", (String)computeNodePlate.getSlotHttpsPort());
            Element snmpPortNode = XmlWriter.createTagElement((Document)hwServerDocument, (String)"snmpPort", (String)computeNodePlate.getSlotSNMPPort());
            soltInfoNode.appendChild(soltIdNode);
            soltInfoNode.appendChild(userNameNode);
            soltInfoNode.appendChild(pwdNode);
            soltInfoNode.appendChild(snmpPwdNode);
            soltInfoNode.appendChild(sshPortNode);
            soltInfoNode.appendChild(ipmiPortNode);
            soltInfoNode.appendChild(httpsPortNode);
            soltInfoNode.appendChild(snmpPortNode);
            slotsInfosNodes.appendChild(soltInfoNode);
        }
        servers.appendChild(applyToOther);
        servers.appendChild(slotsInfosNodes);
    }
}

