/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.worktaker.impl;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.devicecenter.driver.manager.DriverManage;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.ModelDriver;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.worktaker.IDeviceDriverWorktaker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DeviceDriverWorktakerImpl
implements IDeviceDriverWorktaker {
    private List<AbstractDevice> storageDeviceList = new ArrayList<AbstractDevice>();
    private List<AbstractDevice> serverDeviceList = new ArrayList<AbstractDevice>();
    private List<AbstractDevice> cloudDeviceList = new ArrayList<AbstractDevice>();
    private List<AbstractDevice> eSightDeviceList = new ArrayList<AbstractDevice>();
    private TotalDriverResult totalDriverResult = new TotalDriverResult();

    private void clearAllDeviceList() {
        this.storageDeviceList.clear();
        this.serverDeviceList.clear();
        this.cloudDeviceList.clear();
        this.eSightDeviceList.clear();
        this.totalDriverResult = new TotalDriverResult();
    }

    @Override
    public String loginAndQuery(List<AbstractDevice> deviceList, TaskType mode) {
        ModelDriver driver;
        String taskId = this.generateTaskIdByMode(mode);
        this.clearAllDeviceList();
        for (AbstractDevice device : deviceList) {
            this.serverDeviceList.add(device);
        }
        if (!this.serverDeviceList.isEmpty() && null != (driver = DriverManage.getInstance().getDriver(mode, ITDeviceType.SERVER_IBMC))) {
            ArrayList<KeyValue<String, String>> paramList = new ArrayList<KeyValue<String, String>>();
            driver.exec(this.serverDeviceList, paramList, taskId, "");
        }
        return taskId;
    }

    private String generateTaskIdByMode(TaskType mode) {
        StringBuffer taskIdGenerator = new StringBuffer();
        taskIdGenerator.append(mode.getName()).append(DateUtil.getDateTime((String)"yyyyMMddHHmmss", (Date)new Date()));
        return taskIdGenerator.toString();
    }

    @Override
    public TotalDriverResult getDriverResult(String taskID) {
        DriverResult serverResult = null;
        ModelDriver serverDriver = DriverManage.getInstance().getDriver(TaskType.DEV_ADD, ITDeviceType.SERVER_IBMC);
        serverResult = null != serverDriver ? serverDriver.queryResult("", taskID) : new DriverResult();
        if (null != serverResult) {
            this.totalDriverResult.getTotalDriverResultMap().put(ITDeviceType.SERVER_IBMC, serverResult);
        }
        this.totalDriverResult.update();
        return this.totalDriverResult;
    }

    @Override
    public void clearProgressFile(String taskID) {
        ModelDriver serverDriver = DriverManage.getInstance().getDriver(TaskType.DEV_ADD, ITDeviceType.SERVER_IBMC);
        if (null != serverDriver) {
            serverDriver.clearProcessFile(null, taskID, true);
        }
    }

    @Override
    public void backupProgressFile(String taskID) {
        ModelDriver serverDriver = DriverManage.getInstance().getDriver(TaskType.DEV_ADD, ITDeviceType.SERVER_IBMC);
        if (null != serverDriver) {
            serverDriver.backupProcessFile(null, taskID);
        }
    }
}

