/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.us.common.file.UsFileSaxParser;
import com.huawei.us.common.file.UsFileSaxXlsParser;
import com.huawei.us.common.file.api.OverrideProps;
import com.huawei.us.common.file.excel.UsXlsxPoiUtils;
import com.huawei.us.common.file.exception.CsvInjectionException;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UsFileExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(UsFileExcelUtils.class);

    UsFileExcelUtils() {
    }

    static String check(File file, String fileType) {
        return UsFileExcelUtils.check(file, fileType, OverrideProps.builder().build());
    }

    static String check(File file, String fileType, OverrideProps props) {
        try {
            Class.forName("org.apache.poi.ss.usermodel.Workbook");
        }
        catch (ClassNotFoundException e) {
            logger.error("[US-FILE] Excel file found. you need import poi.", (Throwable)e);
            return "9";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"xlsx")) {
            try {
                Class.forName("com.alibaba.excel.EasyExcel");
                return UsFileSaxParser.checkXlsxFile(file, props);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                logger.info("[US-FILE] xlsx file found! It is recommended to use easyExcel! {}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                logger.warn("[US-FILE] Parse xlsx file failed: {}", (Object)e.getMessage());
                return "0";
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"xls")) {
            try {
                UsFileSaxXlsParser xlsSaxParser = new UsFileSaxXlsParser();
                xlsSaxParser.check(file, props);
                return "0";
            }
            catch (CsvInjectionException e) {
                return "4";
            }
            catch (Throwable e) {
                logger.warn("[US-FILE] Parse xls file failed: {}", (Object)e.getMessage());
                return "0";
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"xlsx")) {
            try {
                return UsXlsxPoiUtils.checkXlsxFile(file);
            }
            catch (Throwable e) {
                logger.warn("[US-FILE] Parse excel file by poi failed: {}", (Object)e.getMessage());
                return "0";
            }
        }
        return "0";
    }
}

