/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.exception.UnsupportedRarV5Exception;
import com.github.junrar.rarfile.FileHeader;
import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.file.api.CompressedFileCheckList;
import com.huawei.us.common.file.api.RarCheckOutputstream;
import com.huawei.us.common.file.api.RarOversizeException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UsFileForRar {
    private static final Logger logger = LoggerFactory.getLogger(UsFileForRar.class);

    UsFileForRar() {
    }

    static String checkRarCompressedFile(File file, File tempDirFile, CompressedFileCheckList cfcl, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypeList) {
        long maxSize = cfcl.getMaxSize();
        long maxCount = cfcl.getMaxCount();
        return UsFileForRar.checkCompressedFile(file, tempDirFile, cfcl, checkSubFileByWhiteList, subFileTypeList, maxSize, maxCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String checkCompressedFile(File file, File tempDirFile, CompressedFileCheckList cfcl, boolean checkSubFileByWhiteList, String[] subFileTypeList, long maxSize, long maxCount) {
        long entries = 0L;
        long size = 0L;
        try (RarCheckOutputstream rarCheckOutputstream = new RarCheckOutputstream(maxSize);
             Archive archive = new Archive(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            String result = UsFileForRar.checkUnRar(archive, tempDirFile);
            if (!"0".equals(result)) {
                String string = result;
                return string;
            }
            Iterator iterator = archive.getFileHeaders().iterator();
            while (iterator.hasNext()) {
                if (++entries > maxCount) {
                    logger.error("[US-FILE] Too many sub files in compressed package.");
                    String string = "3";
                    return string;
                }
                FileHeader entry = (FileHeader)iterator.next();
                String name = UsFileUtils.sanitizeFileName(entry.getFileName(), tempDirFile.getCanonicalPath());
                if (entry.isDirectory()) {
                    if (UsFileUtils.makeDirIfNotExist(name)) continue;
                    logger.error("[US-FILE] Mkdir failed: {}", (Object)name);
                    String string = "9";
                    return string;
                }
                if (!UsFileUtils.makeParentDirIfNotExist(name)) {
                    logger.error("[US-FILE] Mkdir failed: {}", (Object)name);
                    String string = "9";
                    return string;
                }
                if (!UsFileUtils.checkFileTypeForZip(entry.getFileName(), checkSubFileByWhiteList, subFileTypeList)) {
                    logger.error("[US-FILE] Check file type failed: {}", (Object)entry.getFileName());
                    String string = "2";
                    return string;
                }
                rarCheckOutputstream.setFile(name);
                archive.extractFile(entry, (OutputStream)rarCheckOutputstream);
                size = rarCheckOutputstream.getSize();
            }
        }
        catch (UnsupportedRarV5Exception e) {
            logger.error("[US-FILE] Unsupported type rar V5: {}", (Object)UsFileUtils.getFileName(file));
            return "2001";
        }
        catch (RarException e) {
            return UsFileForRar.dealRarException(e, file);
        }
        catch (Throwable e) {
            return UsFileForRar.dealThrowable(e, file);
        }
        cfcl.setMaxCount(cfcl.getMaxCount() - entries);
        cfcl.setMaxSize(cfcl.getMaxSize() - size);
        return "0";
    }

    private static String checkUnRar(Archive archive, File tempDirFile) throws IOException {
        if (archive.getFileHeaders().isEmpty()) {
            logger.error("[US-FILE] Reading rar file content failed, the rar file is empty.");
            return "9";
        }
        if (!tempDirFile.mkdir()) {
            logger.error("[US-FILE] Mkdir failed: {}", (Object)tempDirFile.getCanonicalPath());
            return "9";
        }
        return "0";
    }

    private static String dealRarException(RarException e, File file) {
        Throwable cause = e.getCause();
        if (cause.getClass() == RarOversizeException.class) {
            logger.error(cause.getMessage());
            return "3";
        }
        logger.error("[US-FILE] Check rar compressed file failed: {}", (Object)UsFileUtils.getFileName(file), (Object)e);
        return "9";
    }

    private static String dealThrowable(Throwable e, File file) {
        logger.error("[US-FILE] Check rar compressed file failed: {}", (Object)UsFileUtils.getFileName(file), (Object)e);
        return "9";
    }
}

