/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.file.api.CompressedFileCheckList;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UsFileForSevenZ {
    private static final Logger logger = LoggerFactory.getLogger(UsFileForSevenZ.class);

    UsFileForSevenZ() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String checkSevenZCompressedFile(File file, File tempDirFile, CompressedFileCheckList cfcl, Charset charset, boolean checkSubFileByWhiteList, String[] subFileTypeList) {
        try (SevenZFile sevenZFile = new SevenZFile(file);){
            String string = UsFileForSevenZ.checkSevenZCompressedFile(tempDirFile, cfcl, checkSubFileByWhiteList, subFileTypeList, sevenZFile);
            return string;
        }
        catch (Throwable e) {
            logger.error("checkTarCompressedFile failed:{}", (Object)UsFileUtils.getFileName(file), (Object)e);
            return "9";
        }
    }

    private static String checkSevenZCompressedFile(File tempDirFile, CompressedFileCheckList cfcl, boolean checkSubFileByWhiteList, String[] subFileTypeList, SevenZFile sevenZFile) throws IOException {
        long maxSize = cfcl.getMaxSize();
        long maxCount = cfcl.getMaxCount();
        int buffer = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"us.file.extract_buffer_size", (String)"512"));
        if (!tempDirFile.mkdir()) {
            logger.error("mkdir failed: {}", (Object)tempDirFile.getCanonicalPath());
            return "9";
        }
        ArchiveEntry entry = null;
        FileOutputStream fos = null;
        BufferedOutputStream dest = null;
        byte[] data = new byte[buffer];
        String result = UsFileForSevenZ.checkCompressDir(tempDirFile, entry, maxSize, maxCount, buffer, fos, dest, cfcl, checkSubFileByWhiteList, subFileTypeList, sevenZFile, data);
        if ("3".equals(result) || "9".equals(result) || "2".equals(result)) {
            return result;
        }
        return "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String checkCompressDir(File tempDirFile, ArchiveEntry entry, long maxSize, long maxCount, int buffer, FileOutputStream fos, BufferedOutputStream dest, CompressedFileCheckList cfcl, boolean checkSubFileByWhiteList, String[] subFileTypeList, SevenZFile sevenZFile, byte[] data) throws IOException {
        long entries = 0L;
        long total = 0L;
        while ((entry = sevenZFile.getNextEntry()) != null) {
            try {
                int count;
                if (++entries > maxCount) {
                    logger.error("entries count check failed: {}", (Object)entries);
                    String string = "3";
                    return string;
                }
                String name = UsFileUtils.sanitizeFileName(entry.getName(), tempDirFile.getCanonicalPath());
                if (entry.isDirectory()) {
                    if (UsFileUtils.makeDirIfNotExist(name)) continue;
                    logger.error("mkdir failed: {}", (Object)name);
                    String string = "9";
                    return string;
                }
                if (!UsFileUtils.checkFileTypeForZip(entry.getName(), checkSubFileByWhiteList, subFileTypeList)) {
                    logger.error("checkFileType failed: {}", (Object)entry.getName());
                    String string = "2";
                    return string;
                }
                UsFileUtils.makeParentDirIfNotExist(name);
                fos = new FileOutputStream(name);
                dest = new BufferedOutputStream(fos, buffer);
                while (total <= maxSize && (count = sevenZFile.read(data, 0, buffer)) != -1) {
                    dest.write(data, 0, count);
                    total += (long)count;
                }
                if (total <= maxSize) continue;
                logger.error("total size check failed: {}", (Object)total);
                String string = "3";
                return string;
            }
            finally {
                UsFileForSevenZ.closeInputStream(fos, dest);
            }
        }
        cfcl.setMaxCount(cfcl.getMaxCount() - entries);
        cfcl.setMaxSize(cfcl.getMaxSize() - total);
        return "0";
    }

    private static void closeInputStream(FileOutputStream fos, BufferedOutputStream dest) throws IOException {
        if (dest != null) {
            dest.flush();
            dest.close();
        }
        if (fos != null) {
            fos.close();
        }
    }
}

