/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file;

import com.huawei.security.checkengine.RuleEngineManager;
import com.huawei.security.checkengine.bean.CheckResult;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsFileWsfTools {
    private static final Logger logger = LoggerFactory.getLogger(UsFileWsfTools.class);
    private static final String WSF_FILE_TYPE_ERROR = "type";
    private static final String WSF_FILE_SIZE_ERROR = "size";
    private static Properties properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String checkFileByWsf(File file, String realFileType, long size) throws FileNotFoundException, RuleLoadingException {
        if (file.length() <= 22L && "zip".equalsIgnoreCase(realFileType)) {
            return "0";
        }
        InputStream inputStream = null;
        try {
            CheckTypeEnum[] checkTypeArray;
            CheckResult checkResult;
            CheckTypeEnum cte = CheckTypeEnum.getEnumFromString((String)realFileType);
            if (!cte.equals((Object)CheckTypeEnum.OTHERTYPE) && !(checkResult = RuleEngineManager.fileContentCheck((InputStream)(inputStream = new FileInputStream(file)), (CheckTypeEnum[])(checkTypeArray = new CheckTypeEnum[]{cte}), (boolean)true, (Properties)UsFileWsfTools.getProperties(size))).isValidateResule()) {
                String errorMsg = checkResult.getErrorMessage();
                logger.error("wsf checkFile failed: {}", (Object)errorMsg);
                if (StringUtils.contains((CharSequence)errorMsg, (CharSequence)WSF_FILE_TYPE_ERROR)) {
                    String string = "2";
                    return string;
                }
                if (StringUtils.contains((CharSequence)errorMsg, (CharSequence)WSF_FILE_SIZE_ERROR)) {
                    String string = "3";
                    return string;
                }
                String string = "9";
                return string;
            }
        }
        catch (NoClassDefFoundError e) {
            logger.warn("if you want to use wsf to check file ,please import huawei-secure-checkengine", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("Filed to close outputStream! ");
            }
        }
        return "0";
    }

    public static void setProperties(Properties input) {
        if (properties != null) {
            properties.clear();
        }
        if (input == null) {
            properties = null;
        }
        properties = input;
    }

    private static Properties getProperties(long size) {
        if (null == properties) {
            Properties propertiesOnce = new Properties();
            long sizeM = size / 0x100000L;
            propertiesOnce.setProperty("zipBombThresholdTotalSize", String.valueOf(sizeM + 1L));
            int count = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"us.file.file_number_limit", (String)"10240"));
            propertiesOnce.setProperty("zipBombThresholdFileCount", String.valueOf(count));
            return propertiesOnce;
        }
        return properties;
    }

    static {
        System.setProperty("wsf.empty.folder.check.skipping", "true");
        logger.info("[US-FILE] Set wsf property 'wsf.empty.folder.check.skipping' to true.");
    }
}

