/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.csv;

import com.huawei.us.common.file.UsFileUtils;
import com.huawei.us.common.file.bom.ByteOrderMark;
import com.huawei.us.common.file.csv.CsvFileCharset;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFileReader {
    private static final Logger logger = LoggerFactory.getLogger(CsvFileReader.class);

    public static String checkCsvFile(File file) {
        Charset bomCharset = ByteOrderMark.getBOMCharset(file);
        if (bomCharset != null) {
            return CsvFileReader.checkCsvFile(file, bomCharset);
        }
        for (Charset charset : CsvFileCharset.CHARSETS) {
            String result = CsvFileReader.checkCsvFile(file, charset);
            if ("0".equals(result)) continue;
            return result;
        }
        return "0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkCsvFile(File file, Charset charset) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try (FileInputStream fs = new FileInputStream(file);
             InputStreamReader is = new InputStreamReader((InputStream)fs, charset);
             BufferedReader reader = new BufferedReader(is);){
            String line;
            int lineNum = 0;
            do {
                if ((line = reader.readLine()) == null) return "0";
                ++lineNum;
            } while (UsFileUtils.validateCsvStringBlack(line.replaceAll("\ufeff", "")));
            logger.error("[US-FILE] illegal file found...({})", (Object)file.getName());
            logger.error("[US-FILE] illegal text found...({})", (Object)lineNum);
            String string = "4";
            return string;
        }
        catch (IOException e) {
            logger.error("[US-FILE] File parsing failed!", (Throwable)e);
            return "9";
        }
    }
}

