/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.file.excel;

import com.huawei.us.common.file.excel.XlsxDdeChecker;
import com.huawei.us.common.file.excel.XlsxPoiSheetHandler;
import com.huawei.us.common.file.excel.XmlParser;
import com.huawei.us.common.file.exception.CsvInjectionException;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsXlsxPoiUtils {
    private static final Logger logger = LoggerFactory.getLogger(UsXlsxPoiUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkXlsxFile(File file) {
        try (OPCPackage pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            if (XlsxDdeChecker.isContainDdeLink(pkg)) {
                logger.error("[US-FILE] DDE link find in .xlsx file: {}", (Object)file.getName());
                String string = "4";
                return string;
            }
            XSSFReader reader = new XSSFReader(pkg);
            Iterator sheets = reader.getSheetsData();
            while (sheets.hasNext()) {
                InputStream sheet = (InputStream)sheets.next();
                XmlParser.parseXmlSource(sheet, new XlsxPoiSheetHandler());
            }
            return "0";
        }
        catch (CsvInjectionException e) {
            return "4";
        }
        catch (Throwable e) {
            logger.error("[US-FILE] Parse file failed: ", e);
        }
        return "0";
    }
}

