/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.checktqlinject;

import com.huawei.us.common.checktqlinject.api.JsFileParse;
import com.huawei.us.common.checktqlinject.pojo.JsParseResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class JavaParseJsUtil {
    private static final String GROUP_BRACE = "[(]([^()]*?)[)]";
    private static final String TRANSFER_FLAG = "\\'\\$([^\"]*)";
    private static final String TRANSFER_FLAG_TWO = "\"\\$([^\"]*)";
    private static final String SINGLE_QUOTATION = "'(.*?)'";
    private static final String DOUBLE_QUOTATION = "\\\"(.*?)\\\"";
    private static final String NO_TQL_INJECT = "0";
    private static final String IS_TQL_INJECT = "1";
    private static final Pattern MATCH_SINGLE_QUOTATION = Pattern.compile("'(.*?)'", 2);
    private static final Pattern MATCH_DOUBLE_QUOTATION = Pattern.compile("\\\"(.*?)\\\"", 2);
    private static final Pattern MATCH_GROUP_BRACE = Pattern.compile("[(]([^()]*?)[)]", 2);
    private static final String CONTAIN_STRING = "RunScriptUtil.tqlEscape|TQL.escapeIdentifier|TQL.escapeString|([1-9]\\d*\\.?\\d*)|(0\\.\\d*[1-9])|\\)|\\(";
    private static final Pattern MATCH_CONTAIN_STRING = Pattern.compile("RunScriptUtil.tqlEscape|TQL.escapeIdentifier|TQL.escapeString|([1-9]\\d*\\.?\\d*)|(0\\.\\d*[1-9])|\\)|\\(", 2);
    private static final String CONTAIN_STRING_TWO = "cloudserviceaccessor.process|fileStr.contains|serviceinvoker.delete|serviceinvoker.post|serviceinvoker.get|serviceinvoker.put";
    private static final String CONTAIN_STRING_THREE = "exec|alter|drop|creat|insert+.*into|select+.*from|delete+.*from|update+.*set";
    private static final String CONTAIN_STRING_FOUR = "update|tql:|.tql =|insert+.*into|select+.*from|delete+.*from|update+.*set";
    private static final String CONTAIN_STRING_FIVE = "RunScriptUtil.tqlEscape|TQL.escapeString";
    private static final Pattern MATCH_CONTAIN_STRING_TWO = Pattern.compile("cloudserviceaccessor.process|fileStr.contains|serviceinvoker.delete|serviceinvoker.post|serviceinvoker.get|serviceinvoker.put", 2);
    private static final Pattern MATCH_CONTAIN_STRING_THREE = Pattern.compile("exec|alter|drop|creat|insert+.*into|select+.*from|delete+.*from|update+.*set", 2);
    private static final Pattern MATCH_CONTAIN_STRING_FOUR = Pattern.compile("update|tql:|.tql =|insert+.*into|select+.*from|delete+.*from|update+.*set", 2);
    private static final Pattern MATCH_CONTAIN_STRING_FIVE = Pattern.compile("RunScriptUtil.tqlEscape|TQL.escapeString", 2);
    private static final Pattern MATCH_TRANSFER_FLAG = Pattern.compile("\\'\\$([^\"]*)", 2);
    private static final Pattern MATCH_TRANSFER_FLAG_TWO = Pattern.compile("\"\\$([^\"]*)", 2);
    private static final int SUBSTRING_START = 0;
    private static final int SUBSTRING_ONE = 1;
    private static final String TQL_MAP_KEY_SQL = "sqlMap";
    private static final String TQL_MAP_KEY_PREPROCESS = "preprocesMap";
    private static final String TQL_MAP_KEY_SQL_SPLICE = "sqlSplicePosition";
    private static final String TQL_MAP_KEY_KEYWORD = "keywordTql";
    private static final String TQL_MAP_KEY_LINE_TYPE = "lineType";
    private static final String JS_PARSE_STR_MAIN = "Main SQL Line Number:";
    private static final String JS_PARSE_STR_ADD = "Concatenate SQL Line Number:";

    public static JsParseResult javaParesJs(String filePath) {
        String fileStr = JsFileParse.fileReader(filePath);
        File file = new File(filePath);
        String fileName = file.getName();
        JsParseResult jsParseResult = new JsParseResult();
        jsParseResult.setIsExistTql(NO_TQL_INJECT);
        jsParseResult.setFileName(fileName);
        if (!fileName.endsWith(".js")) {
            jsParseResult.setErrorMsg("The file is not a JS file and cannot be parsed.");
            return jsParseResult;
        }
        boolean isContainTql = JavaParseJsUtil.isContainTql(fileStr);
        if (isContainTql) {
            ArrayList<String> list = new ArrayList<String>();
            Map<String, Map<String, String>> preprocesAndSqlsMap = JsFileParse.getMap(filePath);
            Map<String, String> sqlMap = preprocesAndSqlsMap.get(TQL_MAP_KEY_SQL);
            Map<String, String> preprocessMap = preprocesAndSqlsMap.get(TQL_MAP_KEY_PREPROCESS);
            Map<String, String> sqlSplicePosition = preprocesAndSqlsMap.get(TQL_MAP_KEY_SQL_SPLICE);
            Map<String, String> keywordTql = preprocesAndSqlsMap.get(TQL_MAP_KEY_KEYWORD);
            Map<String, String> lineTypeMap = preprocesAndSqlsMap.get(TQL_MAP_KEY_LINE_TYPE);
            for (Map.Entry<String, String> sqlMapEntry : sqlMap.entrySet()) {
                String result;
                String sqlMapKey = sqlMapEntry.getKey();
                String sqlMapValue = sqlMapEntry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)sqlMapValue) || !StringUtils.isNotBlank((CharSequence)(result = JavaParseJsUtil.getString(sqlMapValue = sqlMapValue.trim(), sqlSplicePosition, sqlMapKey, preprocessMap)))) continue;
                list.add(result);
            }
            JavaParseJsUtil.dealWhile(list, keywordTql, preprocessMap, lineTypeMap);
            if (!CollectionUtils.isEmpty(list)) {
                jsParseResult.setIsExistTql(IS_TQL_INJECT);
                jsParseResult.setDetails(list);
            }
        }
        return jsParseResult;
    }

    private static void dealWhile(List<String> list, Map<String, String> keywordTql, Map<String, String> preprocessMap, Map<String, String> lineTypeMap) {
        Iterator<Map.Entry<String, String>> keywordTqlEntries = keywordTql.entrySet().iterator();
        while (keywordTqlEntries.hasNext()) {
            ArrayList<Integer> preprocessList = new ArrayList<Integer>();
            Map.Entry<String, String> keywordTqlEntry = keywordTqlEntries.next();
            String sqlMapKey = keywordTqlEntry.getKey();
            preprocessList.add(Integer.parseInt(sqlMapKey));
            String sqlMapValue = keywordTqlEntry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)sqlMapValue)) continue;
            sqlMapValue = sqlMapValue.trim();
            boolean isOk = JavaParseJsUtil.isTqlKeyWordInject(sqlMapValue);
            StringBuffer stringBuffer = new StringBuffer();
            if (isOk) {
                Iterator<Map.Entry<String, String>> lineTypeEntries = lineTypeMap.entrySet().iterator();
                boolean isExistMainLineNo = false;
                while (lineTypeEntries.hasNext()) {
                    Map.Entry<String, String> lineTypeEntry = lineTypeEntries.next();
                    String lineTypeKey = lineTypeEntry.getKey();
                    if (!lineTypeKey.startsWith(sqlMapKey)) continue;
                    String lineTypeValue = lineTypeEntry.getValue();
                    if (lineTypeValue.startsWith(JS_PARSE_STR_MAIN)) {
                        isExistMainLineNo = true;
                    }
                    stringBuffer.append(lineTypeValue + ";");
                }
                if (isExistMainLineNo) {
                    stringBuffer.append(JS_PARSE_STR_ADD + sqlMapKey + ";");
                } else {
                    stringBuffer.append(JS_PARSE_STR_MAIN + sqlMapKey + ";");
                }
                stringBuffer.append(JsFileParse.getProcessResult(preprocessMap, preprocessList, sqlMapKey));
            }
            if (!StringUtils.isNotBlank((CharSequence)stringBuffer.toString())) continue;
            list.add(stringBuffer.toString());
        }
    }

    public static boolean isTqlStr(String sql) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            String sqlMain = sql;
            String sqlNew = "";
            while (JavaParseJsUtil.isMatchOk(sqlMain, MATCH_GROUP_BRACE)) {
                sqlNew = JavaParseJsUtil.cutStr(sqlMain, MATCH_GROUP_BRACE);
                sqlMain = sqlMain.replace(sqlNew, "param");
                if (!JavaParseJsUtil.isMatchOk(sqlNew, MATCH_CONTAIN_STRING_THREE)) continue;
                return true;
            }
        }
        return JavaParseJsUtil.isTqlInject(sql);
    }

    public static boolean isMatchOk(String code, Pattern pattern) {
        if (StringUtils.isNotBlank((CharSequence)code) && pattern != null) {
            Matcher matcher = pattern.matcher(code);
            return matcher.find();
        }
        return false;
    }

    public static String cutStr(String code, Pattern pattern) {
        String newStr = "";
        Matcher matcher = pattern.matcher(code);
        boolean found = matcher.find();
        if (found) {
            newStr = matcher.group();
        }
        return newStr;
    }

    public static boolean isContainTql(String fileStr) {
        if (StringUtils.isNotBlank((CharSequence)fileStr)) {
            if (JavaParseJsUtil.isMatchOk(fileStr, MATCH_CONTAIN_STRING_TWO)) {
                if (JavaParseJsUtil.isMatchOk(fileStr, MATCH_CONTAIN_STRING_FOUR)) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public static String getString(String sqlMapValue, Map<String, String> sqlSplicePosition, String sqlMapKey, Map<String, String> preprocessMap) {
        StringBuffer stringBuffer = new StringBuffer();
        if (JavaParseJsUtil.isTqlStr(sqlMapValue)) {
            Iterator<Map.Entry<String, String>> sqlSpliceEntries = sqlSplicePosition.entrySet().iterator();
            String sqlMapKeyEnd = "";
            String sqlMapKeyBegin = "";
            ArrayList<Integer> preprocessList = new ArrayList<Integer>();
            if (sqlMapKey.contains("-")) {
                sqlMapKeyBegin = sqlMapKey.substring(0, sqlMapKey.indexOf("-")).trim();
                sqlMapKeyEnd = sqlMapKey.substring(sqlMapKey.indexOf("-") + 1).trim();
                while (sqlSpliceEntries.hasNext()) {
                    Map.Entry<String, String> sqlSpliceEntry = sqlSpliceEntries.next();
                    String sqlSpliceKey = sqlSpliceEntry.getKey();
                    if (!sqlMapKeyBegin.equals(sqlSpliceKey)) continue;
                    stringBuffer.append(JS_PARSE_STR_MAIN + sqlSpliceKey + " ;");
                    if (StringUtils.isNotBlank((CharSequence)sqlMapKeyEnd)) {
                        stringBuffer.append(JS_PARSE_STR_ADD + sqlMapKeyEnd + " ;");
                    }
                    preprocessList.add(Integer.parseInt(sqlMapKeyEnd));
                }
            } else {
                String addStr;
                stringBuffer.append(JS_PARSE_STR_MAIN + sqlMapKey + ";");
                String string = addStr = sqlSplicePosition.get(sqlMapKey) != null ? sqlSplicePosition.get(sqlMapKey) : "";
                if (StringUtils.isNotBlank((CharSequence)addStr)) {
                    stringBuffer.append(JS_PARSE_STR_ADD + addStr + " ;");
                }
                sqlMapKeyEnd = sqlMapKey;
                preprocessList.add(Integer.parseInt(sqlMapKey));
            }
            stringBuffer.append(JsFileParse.getProcessResult(preprocessMap, preprocessList, sqlMapKeyEnd));
        }
        return stringBuffer.toString();
    }

    public static boolean isTqlInject(String sql) {
        String newStr = "";
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            if (!sql.contains("+")) {
                if (sql.contains("$") && !JavaParseJsUtil.isMatchOk(sql, MATCH_TRANSFER_FLAG) && !JavaParseJsUtil.isMatchOk(sql, MATCH_TRANSFER_FLAG_TWO)) {
                    return true;
                }
            } else {
                if ((newStr = JavaParseJsUtil.dealTqlInject(sql, newStr)) == null) {
                    return true;
                }
                if (StringUtils.isNotBlank((CharSequence)newStr)) {
                    String lastStr = JavaParseJsUtil.getStr(newStr);
                    if (lastStr.contains("||")) {
                        return true;
                    }
                    if (lastStr.contains("$") && !JavaParseJsUtil.isMatchOk(sql, MATCH_TRANSFER_FLAG) && !JavaParseJsUtil.isMatchOk(sql, MATCH_TRANSFER_FLAG_TWO)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static String dealTqlInject(String sql, String newStr) {
        String[] items = sql.split("\\+");
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (item.contains("'") || item.contains("\"")) {
                String end;
                String itemNew = item.trim();
                String begin = itemNew.charAt(0) + "";
                if (begin.equals(end = itemNew.charAt(itemNew.length() - 1) + "") && (begin.equals("'") || begin.equals("\""))) {
                    if (itemNew.length() <= 1) continue;
                    newStr = newStr + itemNew.substring(1, itemNew.length() - 1);
                    continue;
                }
                newStr = newStr + itemNew;
                continue;
            }
            if ("".equals(item)) continue;
            if (JavaParseJsUtil.isMatchOk(item, MATCH_CONTAIN_STRING) && !item.contains("(") && !item.contains(")") && !item.contains("(new date()).gettime()")) {
                return null;
            }
            newStr = newStr + "||" + item.trim() + "||";
        }
        return newStr;
    }

    public static boolean isTqlKeyWordInject(String sql) {
        if (sql.contains(" in ") || sql.contains(" exists ")) {
            return JavaParseJsUtil.isTqlInject(sql);
        }
        return false;
    }

    public static String getStr(String newStr) {
        String runStr;
        if (newStr.contains("'")) {
            String runStr2;
            if (JavaParseJsUtil.isMatchOk(newStr, MATCH_CONTAIN_STRING_FIVE) && (runStr2 = JavaParseJsUtil.cutStr(newStr, MATCH_SINGLE_QUOTATION)).contains("'")) {
                newStr = newStr.replace(runStr2, "a");
                return JavaParseJsUtil.getStr(newStr);
            }
        } else if (newStr.contains("\"") && (newStr.contains("TQL.escapeIdentifier") || newStr.contains("TQL.ESCAPEIDENTIFIER") || newStr.contains("tql.escapeidentifier")) && (runStr = JavaParseJsUtil.cutStr(newStr, MATCH_DOUBLE_QUOTATION)).contains("\"")) {
            newStr = newStr.replace(runStr, "a");
            return JavaParseJsUtil.getStr(newStr);
        }
        return newStr;
    }
}

