/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.checktqlinject.api;

import com.huawei.us.common.checktqlinject.api.ScanJsFilePreprocesSqlStr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsFileParse {
    private static final Logger logger = LoggerFactory.getLogger(JsFileParse.class);
    private static final String JS_PARSE_STR_PROCESS = "Execute Line Number:";

    public static String fileReader(String filePath) {
        StringBuffer stringBuffer = new StringBuffer();
        try (BufferedReader bufferedJs = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));){
            JsFileParse.dealLine(bufferedJs, stringBuffer);
        }
        catch (IOException e) {
            logger.debug("Processing trade with fileReader:{}", (Object)"The file is read failed.");
        }
        return stringBuffer.toString();
    }

    private static void dealLine(BufferedReader bufferedJs, StringBuffer stringBuffer) throws IOException {
        String lineStr = bufferedJs.readLine();
        while (lineStr != null) {
            if (lineStr.startsWith("/*") || lineStr.startsWith("*") || lineStr.startsWith("*/")) {
                lineStr = bufferedJs.readLine();
                continue;
            }
            lineStr = bufferedJs.readLine();
            stringBuffer.append(lineStr);
        }
    }

    public static Map<String, Map<String, String>> getMap(String filePath) {
        File file = new File(filePath);
        ScanJsFilePreprocesSqlStr scanJsFilePreprocesSqlStr = new ScanJsFilePreprocesSqlStr();
        HashMap<String, Map<String, String>> preprocesAndSqlsMap = new HashMap();
        try {
            preprocesAndSqlsMap = scanJsFilePreprocesSqlStr.preprocesJsFile(file);
        }
        catch (IOException e) {
            logger.debug("Processing trade with getProcessResult:{}", (Object)"GET Execution Row Number Result");
        }
        return preprocesAndSqlsMap;
    }

    public static String getProcessResult(Map<String, String> preprocessMap, List<Integer> preprocessList, String sqlMapKeyEnd) {
        for (Map.Entry<String, String> preprocessEntry : preprocessMap.entrySet()) {
            String preprocessKey = preprocessEntry.getKey();
            if (!StringUtils.isNotEmpty((CharSequence)preprocessKey)) continue;
            preprocessList.add(Integer.parseInt(preprocessKey));
        }
        Collections.sort(preprocessList);
        String process = JsFileParse.dealResult(preprocessMap, preprocessList, sqlMapKeyEnd);
        if (process != null) {
            return process;
        }
        logger.debug("Processing trade with getProcessResult:{}", (Object)"GET Execution Row Number Result");
        return "";
    }

    private static String dealResult(Map<String, String> preprocessMap, List<Integer> preprocessList, String sqlMapKeyEnd) {
        for (int i = 0; i < preprocessList.size(); ++i) {
            String process = JsFileParse.getResult(preprocessMap, preprocessList, sqlMapKeyEnd, i);
            if (process == null) continue;
            return process;
        }
        return null;
    }

    private static String getResult(Map<String, String> preprocessMap, List<Integer> preprocessList, String sqlMapKeyEnd, int i) {
        String process;
        if (sqlMapKeyEnd.equals(preprocessList.get(i) + "") && i != preprocessList.size() - 1 && (process = preprocessMap.get(preprocessList.get(i + 1) + "")) != null) {
            process = process.substring(process.indexOf("=") + 1, process.indexOf("("));
            return process + JS_PARSE_STR_PROCESS + preprocessList.get(i + 1);
        }
        if (sqlMapKeyEnd.equals(preprocessList.get(i) + "") && i != 0 && (process = preprocessMap.get(preprocessList.get(i - 1) + "")) != null) {
            process = process.substring(process.indexOf("=") + 1, process.indexOf("("));
            return process + JS_PARSE_STR_PROCESS + preprocessList.get(i - 1);
        }
        return null;
    }
}

