/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.http;

import com.huawei.us.common.io.UsIOUtils;
import com.huawei.us.common.resource.SystemConfigUtil;
import com.huawei.us.common.string.UsStringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(UsHttpUtils.class);
    private static List<String> clusterIpList = new ArrayList<String>();

    public static String getRealIP(HttpServletRequest request) {
        String[] headers;
        String clientIP = request.getRemoteAddr();
        String remoteIP = null;
        for (String header : headers = UsStringUtils.strToArray(SystemConfigUtil.getStringValueByName("us.real.ip.header", "X-Forwarded-For"))) {
            if (!StringUtils.isNotEmpty((CharSequence)request.getHeader(header))) continue;
            remoteIP = request.getHeader(header);
            break;
        }
        if (null != clusterIpList && 0 != clusterIpList.size()) {
            return UsHttpUtils.isClusterIP(clientIP) && null != remoteIP ? UsHttpUtils.getRealIpByClientIpAndRemoteIP(clientIP, remoteIP) : clientIP;
        }
        return clientIP;
    }

    public static boolean isClusterIP(String inIP) {
        String clusterIp;
        if (0 == clusterIpList.size()) {
            return true;
        }
        Iterator<String> it = clusterIpList.iterator();
        do {
            if (!it.hasNext()) {
                return false;
            }
            clusterIp = String.valueOf(it.next());
            if (!clusterIp.equalsIgnoreCase(inIP)) continue;
            return true;
        } while (!UsHttpUtils.isInClusterIPSegment(clusterIp, inIP));
        return true;
    }

    public static boolean isInClusterIPSegment(String clusterIpSegment, String inIP) {
        if (clusterIpSegment != null && inIP != null) {
            long ipCheckValue;
            String[] ipCheck = inIP.split("\\.");
            if (ipCheck.length < 4) {
                return false;
            }
            String[] ipSegment = clusterIpSegment.split("-");
            if (ipSegment.length < 2) {
                return false;
            }
            String[] ipStart = ipSegment[0].split("\\.");
            if (ipStart.length < 4) {
                return false;
            }
            String[] ipEnd = ipSegment[1].split("\\.");
            if (ipEnd.length < 4) {
                return false;
            }
            long ipStartValue = Long.parseLong(ipStart[3]) + Long.parseLong(ipStart[2]) * 256L + Long.parseLong(ipStart[1]) * 256L * 256L + Long.parseLong(ipStart[0]) * 256L * 256L * 256L;
            long ipEndValue = Long.parseLong(ipEnd[3]) + Long.parseLong(ipEnd[2]) * 256L + Long.parseLong(ipEnd[1]) * 256L * 256L + Long.parseLong(ipEnd[0]) * 256L * 256L * 256L;
            return ipEndValue >= (ipCheckValue = Long.parseLong(ipCheck[3]) + Long.parseLong(ipCheck[2]) * 256L + Long.parseLong(ipCheck[1]) * 256L * 256L + Long.parseLong(ipCheck[0]) * 256L * 256L * 256L) && ipCheckValue >= ipStartValue;
        }
        return false;
    }

    public static String getRealIpByClientIpAndRemoteIP(String clientIP, String remoteIps) {
        if (null != remoteIps && !remoteIps.equalsIgnoreCase("UNKNOWN")) {
            String ip;
            ArrayList<String> ipList = new ArrayList<String>();
            StringTokenizer ips = new StringTokenizer(remoteIps, " ,;");
            while (ips.hasMoreTokens()) {
                String oneIP = ips.nextToken().trim();
                if (StringUtils.isBlank((CharSequence)oneIP)) continue;
                ipList.add(oneIP);
            }
            ListIterator it = ipList.listIterator(ipList.size());
            do {
                if (it.hasPrevious()) continue;
                return clientIP;
            } while (UsHttpUtils.isClusterIP(ip = (String)it.previous()));
            return ip;
        }
        return clientIP;
    }

    public static byte[] getBody(ServletRequest request) {
        try {
            return UsIOUtils.toByteArray((InputStream)request.getInputStream());
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }

    static List<String> getClusterIpList() {
        return clusterIpList;
    }

    static {
        try {
            String clusterIPListArray = SystemConfigUtil.getStringValueByName("us.cluster.ip.segment", "");
            if (StringUtils.isNotEmpty((CharSequence)clusterIPListArray)) {
                Collections.addAll(clusterIpList, clusterIPListArray.split(","));
            }
        }
        catch (Throwable e) {
            logger.error("UsHttpUtils init error", e);
        }
    }
}

