/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log;

import com.huawei.us.common.log.tools.FilterHttpDataTools;
import com.huawei.us.common.log.tools.SensitiveFilterACTools;
import com.huawei.us.common.log.tools.SensitiveFilterTools;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.spi.LoggingEvent;

public class UsLogUtils {
    private static final String CHAR_SEPARATOR = "#";
    private static final int MSG_MAX_LENGTH = Integer.parseInt(SystemConfigUtil.getStringValueByName("log.message.max.length.in.byte", "2000"));
    private static final String LOG_FILTER_SWITCH = SystemConfigUtil.getStringValueByName("log.filter.ctrl", "on");
    private static final String LOG_FILTER_ALGORITHM = SystemConfigUtil.getStringValueByName("log.filter.algorithm", "regexp");
    private static final String LOG_FILTER_ALGORITHM_REGEXP = "regexp";
    private static final String LOG_FILTER_ALGORITHM_AC = "ac";
    private static final Map<String, String> newLineCharMap = new HashMap<String, String>();
    private static final List<String> replaceChars = new ArrayList<String>();

    private static void loadReplaceChars() {
        String[] replaceNewLineList;
        for (String repChar : replaceNewLineList = SystemConfigUtil.getStringValueByName("log.filter.newline.replace.list", "\\n#\\r#\\f#\\b#\\u007F#\\u000B").split(CHAR_SEPARATOR)) {
            String realStr = newLineCharMap.get(repChar);
            if (realStr != null) {
                replaceChars.add(realStr);
                continue;
            }
            replaceChars.add(repChar);
        }
    }

    public static String filterLogMsg(Object log, boolean isSensitiveFilter) {
        String logStr = UsLogUtils.filterNewlinesInLog(log);
        return isSensitiveFilter ? UsLogUtils.filterSensitiveMsgInLog(logStr) : logStr;
    }

    private static String filterNewlinesInLog(Object log) {
        String logStr = "";
        if (log != null) {
            logStr = log.toString();
            if (MSG_MAX_LENGTH > 0 && MSG_MAX_LENGTH < logStr.length()) {
                logStr = logStr.substring(0, MSG_MAX_LENGTH) + "...";
            }
            for (String rep : replaceChars) {
                logStr = StringUtils.replace((String)logStr, (String)rep, (String)"[N]");
            }
        }
        return logStr;
    }

    public static String filterSensitiveMsgInLog(String logStr) {
        if ("on".equals(LOG_FILTER_SWITCH)) {
            logStr = LOG_FILTER_ALGORITHM_AC.equals(LOG_FILTER_ALGORITHM) ? SensitiveFilterACTools.filterSensitiveMsg(logStr) : SensitiveFilterTools.filterSensitiveMsg(logStr);
            return FilterHttpDataTools.filterHttpData(logStr);
        }
        return logStr;
    }

    public static LoggingEvent buildUsLoggingEvent(LoggingEvent event, boolean isSensitiveFilter) {
        try {
            if (event == null) {
                return null;
            }
            if (event.getMessage() != null) {
                Object oriMsg = event.getMessage();
                Field messageField = event.getClass().getDeclaredField("message");
                messageField.setAccessible(true);
                messageField.set(event, UsLogUtils.filterLogMsg(oriMsg, isSensitiveFilter));
            }
            return event;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            PrintStream sout = System.out;
            sout.println("Unknown log event: " + e.getMessage());
            return null;
        }
    }

    static void reloadReplaceChars() {
        replaceChars.clear();
        UsLogUtils.loadReplaceChars();
    }

    static {
        newLineCharMap.put("\\n", "\n");
        newLineCharMap.put("\\b", "\b");
        newLineCharMap.put("\\f", "\f");
        newLineCharMap.put("\\r", "\r");
        newLineCharMap.put("\\u007F", "\u007f");
        newLineCharMap.put("\\u000B", "\u000b");
        UsLogUtils.loadReplaceChars();
    }
}

