/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.appender;

import com.huawei.us.common.log.UsLogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

@Deprecated
public class UsRollingZipFileAppender
extends FileAppender {
    private static final int BUFFER_GZIP = 0x200000;
    private static final String SUFFIX_GZIP = ".gz";
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;
    private long nextRollover = 0L;
    private ExecutorService logCompressThreadPool = Executors.newSingleThreadExecutor();
    private Future<Boolean> compressLogResult = null;

    public UsRollingZipFileAppender() {
    }

    public UsRollingZipFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public UsRollingZipFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaximumFileSize(long initMaxFileSize) {
        this.maxFileSize = initMaxFileSize;
    }

    public void rollOver() {
        this.getSizeFromQuietWriter();
        boolean renameSucceeded = true;
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(this.fileName + '.' + this.maxBackupIndex + SUFFIX_GZIP);
            renameSucceeded = !file.exists() || file.delete();
            for (int index = this.maxBackupIndex - 1; index >= 1 && renameSucceeded; --index) {
                file = new File(this.fileName + "." + index + SUFFIX_GZIP);
                if (!file.exists()) continue;
                target = new File(this.fileName + '.' + (index + 1) + SUFFIX_GZIP);
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                renameSucceeded = file.renameTo(target);
            }
            if (renameSucceeded) {
                target = new File(this.fileName + "." + 1 + SUFFIX_GZIP);
                this.closeFile();
                LogLog.debug((String)("writeGzip " + this.fileName + " to " + target));
                renameSucceeded = this.writeGzip(target);
                if (!renameSucceeded) {
                    try {
                        this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                    }
                    catch (IOException exception) {
                        if (exception instanceof InterruptedIOException) {
                            Thread.currentThread().interrupt();
                        }
                        LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."), (Throwable)exception);
                    }
                }
            }
        }
        if (renameSucceeded) {
            try {
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
                this.nextRollover = 0L;
            }
            catch (IOException ioException) {
                if (ioException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)ioException);
            }
        }
    }

    private void getSizeFromQuietWriter() {
        if (this.qw != null) {
            long size = 0L;
            if (this.qw instanceof CountingQuietWriter) {
                size = ((CountingQuietWriter)this.qw).getCount();
            }
            LogLog.debug((String)("rolling over count=" + size));
            this.nextRollover = size + this.maxFileSize;
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File file = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(file.length());
        }
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(UsLogUtils.buildUsLoggingEvent(event, true));
        if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover && (this.compressLogResult == null || this.compressLogResult.isDone())) {
            this.rollOver();
        }
    }

    public void append(LoggingEvent event) {
        super.append(UsLogUtils.buildUsLoggingEvent(event, true));
    }

    private boolean writeGzip(File target) {
        File oldLogFile = new File(this.fileName);
        if (oldLogFile.exists()) {
            File tmpFile = new File(this.fileName + "-" + UUID.randomUUID().toString() + ".tmp");
            LogLog.debug((String)("Renaming file " + oldLogFile + " to " + tmpFile));
            boolean renameSucceeded = oldLogFile.renameTo(tmpFile);
            if (renameSucceeded) {
                this.compressLogResult = this.logCompressThreadPool.submit(new LogCompressCallable(tmpFile, target));
                return true;
            }
        }
        return false;
    }

    private static final class LogCompressCallable
    implements Callable<Boolean> {
        private final File sourceFile;
        private final File targetFile;

        public LogCompressCallable(File sourceFile, File targetFile) {
            this.sourceFile = sourceFile;
            this.targetFile = targetFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            boolean sourceFileDel;
            try (FileInputStream fis = new FileInputStream(this.sourceFile);
                 GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(this.targetFile));){
                int count;
                byte[] data = new byte[0x200000];
                while ((count = fis.read(data, 0, 0x200000)) != -1) {
                    out.write(data, 0, count);
                }
            }
            catch (IOException e) {
                LogLog.error((String)("writeGzip(" + this.targetFile.getPath() + ") call failed."), (Throwable)e);
            }
            finally {
                sourceFileDel = this.sourceFile.delete();
            }
            if (!sourceFileDel) {
                LogLog.error((String)("Delete tmp file" + this.sourceFile.getPath() + " after compress failed."));
            }
            return sourceFileDel;
        }
    }
}

