/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.log4j2.layout;

import com.huawei.us.common.log.UsLogUtils;
import com.huawei.us.common.log.log4j2.proxy.UsThrowableProxyProxy;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.RegexReplacement;
import org.apache.logging.log4j.message.Message;

@Plugin(name="UsPatternLayout", category="Core", elementType="layout", printObject=true)
public class UsPatternLayout
extends AbstractStringLayout {
    private PatternLayout patternLayout;
    private String sensitiveFilter;
    private static final String SENSITIVE_FILTER_OFF = "off";

    private UsPatternLayout(Configuration config, RegexReplacement replace, String eventPattern, PatternSelector patternSelector, Charset charset, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi, String headerPattern, String footerPattern, String sensitiveFilter) {
        super(config, charset, PatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPattern(headerPattern).setDefaultPattern(null).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setNoConsoleNoAnsi(noConsoleNoAnsi).build(), PatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPattern(footerPattern).setDefaultPattern(null).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setNoConsoleNoAnsi(noConsoleNoAnsi).build());
        this.sensitiveFilter = sensitiveFilter;
        this.patternLayout = PatternLayout.newBuilder().withPattern(eventPattern).withPatternSelector(patternSelector).withConfiguration(config).withRegexReplacement(replace).withCharset(charset).withAlwaysWriteExceptions(alwaysWriteExceptions).withNoConsoleNoAnsi(noConsoleNoAnsi).withHeader(headerPattern).withFooter(footerPattern).build();
    }

    @PluginFactory
    public static UsPatternLayout buildLayout(@PluginAttribute(value="pattern", defaultString="%m%n") String pattern, @PluginElement(value="PatternSelector") PatternSelector patternSelector, @PluginConfiguration Configuration config, @PluginElement(value="Replace") RegexReplacement replace, @PluginAttribute(value="charset") Charset charset, @PluginAttribute(value="sensitiveFilter") String sensitiveFilter, @PluginAttribute(value="alwaysWriteExceptions", defaultBoolean=true) boolean alwaysWriteExceptions, @PluginAttribute(value="noConsoleNoAnsi") boolean noConsoleNoAnsi, @PluginAttribute(value="header") String headerPattern, @PluginAttribute(value="footer") String footerPattern) {
        return new UsPatternLayout(config, replace, pattern, patternSelector, charset, alwaysWriteExceptions, noConsoleNoAnsi, headerPattern, footerPattern, sensitiveFilter);
    }

    public String toSerializable(LogEvent logEvent) {
        if (logEvent == null) {
            return null;
        }
        Log4jLogEvent.Builder log4j2EventBuilder = new Log4jLogEvent.Builder(logEvent);
        log4j2EventBuilder.setMessage((Message)new SecureMessageWrapper(logEvent.getMessage()));
        if (logEvent.getThrown() != null) {
            log4j2EventBuilder.setThrown(logEvent.getThrown());
            log4j2EventBuilder.setThrownProxy((ThrowableProxy)new UsThrowableProxyProxy(logEvent.getThrownProxy()));
        }
        return this.patternLayout.toSerializable((LogEvent)log4j2EventBuilder.build());
    }

    private class SecureMessageWrapper
    implements Message {
        private static final long serialVersionUID = -8718041785500905828L;
        private Message message;

        SecureMessageWrapper(Message message) {
            this.message = message;
        }

        public String getFormattedMessage() {
            return UsLogUtils.filterLogMsg(this.message.getFormattedMessage(), !UsPatternLayout.SENSITIVE_FILTER_OFF.equals(UsPatternLayout.this.sensitiveFilter));
        }

        public String getFormat() {
            return UsLogUtils.filterLogMsg(this.message.getFormat(), !UsPatternLayout.SENSITIVE_FILTER_OFF.equals(UsPatternLayout.this.sensitiveFilter));
        }

        public Object[] getParameters() {
            return this.message.getParameters();
        }

        public Throwable getThrowable() {
            return this.message.getThrowable();
        }
    }
}

