/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.Compressor;
import com.huawei.us.common.log.UsLogUtils;
import com.huawei.us.common.log.logback.converter.UsExtendedThrowableProxyConverter;
import com.huawei.us.common.log.logback.converter.UsRootCauseFirstThrowableProxyConverter;
import com.huawei.us.common.log.logback.converter.UsThrowableProxyConverter;
import com.huawei.us.common.log.logback.rollingpolicy.UsCompressor;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UsLogbackUtils {
    private static final PrintStream SYS_ERROR = System.err;

    public static void doReflectFilter(ILoggingEvent event, boolean isSensitiveFilter) throws NoSuchFieldException, IllegalAccessException {
        String oriMsg = event.getMessage();
        Field messageField = event.getClass().getDeclaredField("message");
        messageField.setAccessible(true);
        messageField.set(event, UsLogUtils.filterLogMsg(oriMsg, isSensitiveFilter));
        String oriFormattedMsg = event.getFormattedMessage();
        Field formattedMessageField = event.getClass().getDeclaredField("formattedMessage");
        formattedMessageField.setAccessible(true);
        formattedMessageField.set(event, UsLogUtils.filterLogMsg(oriFormattedMsg, isSensitiveFilter));
    }

    public static void initUsThrowableConverterMap() {
        Set<Class> usConverterSet = Stream.of(UsThrowableProxyConverter.class, UsExtendedThrowableProxyConverter.class, UsRootCauseFirstThrowableProxyConverter.class).collect(Collectors.toSet());
        usConverterSet.forEach(usConverter -> PatternLayout.defaultConverterMap.entrySet().stream().filter(entry -> usConverter.getSuperclass().getName().equals(entry.getValue())).forEach(entry -> entry.setValue(usConverter.getName())));
    }

    public static void decorateUsCompressor(RollingPolicy rollingPolicy) {
        if (rollingPolicy instanceof TimeBasedRollingPolicy) {
            UsLogbackUtils.decorateUsCompressor(TimeBasedRollingPolicy.class, rollingPolicy);
            return;
        }
        if (rollingPolicy instanceof FixedWindowRollingPolicy) {
            UsLogbackUtils.decorateUsCompressor(FixedWindowRollingPolicy.class, rollingPolicy);
        }
    }

    public static void decorateUsCompressor(Class<?> clazz, RollingPolicy rollingPolicy) {
        try {
            Field field = clazz.getDeclaredField("compressor");
            field.setAccessible(true);
            Compressor compressor = (Compressor)field.get(rollingPolicy);
            if (!(compressor instanceof UsCompressor)) {
                field.set(rollingPolicy, (Object)new UsCompressor(rollingPolicy.getCompressionMode(), compressor));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            String errMsg = String.format(Locale.ENGLISH, "warn: configure archive file rolling appender failed: %s, archive compressed log file permission may not correct", e.getMessage());
            SYS_ERROR.println(errMsg);
        }
    }
}

