/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.core;

import com.huawei.us.common.regexfuzzer.core.State;

public class Result {
    private final State state;
    private final String payload;
    private final int maxPayloadSize;

    public Result(State state, int maxPayloadSize, String payload) {
        this.state = state;
        this.maxPayloadSize = maxPayloadSize;
        this.payload = payload;
    }

    public State state() {
        return this.state;
    }

    public String payload() {
        return this.payload;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public String toString() {
        if (this.state.equals((Object)State.VULNERABLE)) {
            return "This regex is vulnerable." + System.lineSeparator() + "Poc is: " + this.payload;
        }
        if (this.state.equals((Object)State.NOT_VULNERABLE)) {
            return "This regex is not vulnerable.";
        }
        if (this.state.equals((Object)State.TIME_OUT)) {
            return "This regex is probably not vulnerable, when tested time < 1 minute.";
        }
        if (this.state.equals((Object)State.PROBABLY_NOT_VULNERABLE)) {
            return "This regex is probably not vulnerable, when tested payload sizes < " + this.maxPayloadSize;
        }
        return "Cannot tell wether this regex is vulnerable or not.";
    }
}

