/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.executor;

import com.huawei.us.common.regexfuzzer.executor.DaemonThreadFactory;
import com.huawei.us.common.regexfuzzer.utils.UnKnownException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutExecutor.class);
    private final ExecutorService service;
    private final long timeout;
    private final TimeUnit unit;

    public TimeoutExecutor(ExecutorService service, long timeout, TimeUnit unit) {
        this.service = service;
        this.timeout = timeout;
        this.unit = unit;
    }

    public TimeoutExecutor(int threads, long timeout, TimeUnit unit) {
        this.service = Executors.newFixedThreadPool(threads, new DaemonThreadFactory());
        this.timeout = timeout;
        this.unit = unit;
    }

    public <T> T execute(Callable<T> task, ExceptionMapper handler) {
        Future<T> result = this.service.submit(task);
        try {
            return result.get(this.timeout, this.unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("execute error!", (Throwable)e);
            result.cancel(true);
            throw handler.map(e);
        }
    }

    public <T> T execute(Callable<T> task, long timeOut, TimeUnit unit) throws TimeoutException, UnKnownException {
        Future<T> result = this.service.submit(task);
        try {
            return result.get(timeOut, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Execute error! Cannot tell whether this expression is vulnerable or not.", (Throwable)e);
            result.cancel(true);
            throw new UnKnownException(e.getMessage());
        }
        catch (TimeoutException e) {
            logger.error("TimeoutException! timeOut: {}, unit: {}", (Object)timeOut, (Object)unit);
            result.cancel(true);
            throw e;
        }
    }

    public void shutDown() {
        this.service.shutdownNow();
    }

    public static class ExceptionMapper {
        public RuntimeException map(Exception exception) {
            if (exception instanceof ExecutionException) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new IllegalStateException(throwable);
            }
            throw new IllegalStateException(exception);
        }
    }
}

