/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.executor;

import com.huawei.us.common.regexfuzzer.core.Result;
import com.huawei.us.common.regexfuzzer.core.State;
import com.huawei.us.common.regexfuzzer.executor.TimeoutExecutor;
import com.huawei.us.common.regexfuzzer.expressions.Atom;
import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.parser.RegexParser;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.SimpleStrategy;
import com.huawei.us.common.regexfuzzer.strategy.VaryingRepetition;
import com.huawei.us.common.regexfuzzer.utils.RegexUtils;
import com.huawei.us.common.regexfuzzer.utils.TimeOutException;
import com.huawei.us.common.regexfuzzer.utils.UnKnownException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutRegexFuzzer {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutRegexFuzzer.class);
    private static final TimeoutExecutor.ExceptionMapper MAPPER = new TimeoutExecutor.ExceptionMapper();
    private final TimeoutExecutor executor;

    public TimeoutRegexFuzzer(TimeoutExecutor executor) {
        this.executor = executor;
    }

    public TimeoutRegexFuzzer() {
        this(new TimeoutExecutor(5, 120L, TimeUnit.SECONDS));
    }

    public Boolean fuzz(String regex) {
        return this.executor.execute(() -> this.isVulnerable(regex), MAPPER);
    }

    public Boolean fuzz(String regex, int timeout) {
        return this.executor.execute(() -> this.isVulnerable(regex, timeout), MAPPER);
    }

    public Boolean fuzz(String regex, int timeout, boolean strongMode) {
        return this.executor.execute(() -> this.isVulnerable(regex, timeout, strongMode), MAPPER);
    }

    public void shutDown() {
        this.executor.shutDown();
    }

    public boolean isVulnerable(String regex) {
        return this.isVulnerable(regex, -1);
    }

    public boolean isVulnerable(String regex, int timeout) {
        return this.isVulnerable(regex, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVulnerable(String regex, int timeout, boolean strongMode) {
        Result result = new Result(State.DONT_KNOW, 0, "");
        try {
            result = this.parseAndFuzz(regex, timeout, strongMode);
            boolean bl = result.state().equals((Object)State.VULNERABLE);
            return bl;
        }
        catch (PatternSyntaxException e) {
            logger.error("An error occurred when check the pattern.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.debug("Testing:[{}] ;result:[{}]", (Object)regex, (Object)result);
        }
    }

    private Result parseAndFuzz(String regex, int timeout, boolean strongMode) {
        Pattern pattern = Pattern.compile(regex);
        RegexParser parser = new RegexParser(regex);
        Expression expression = parser.getResult();
        if (expression == null) {
            return new Result(State.NOT_VULNERABLE, 0, "");
        }
        if (strongMode) {
            return this.fuzzStrongMode(pattern, expression, timeout);
        }
        return this.fuzz(pattern, expression, timeout);
    }

    private Result fuzz(Pattern pattern, Expression expression, int timeout) {
        Payloads payloads;
        int tests = 0;
        VaryingRepetition strategy = new VaryingRepetition(100, 5000, 3000, timeout);
        try {
            payloads = expression.payloads(strategy);
        }
        catch (TimeOutException e) {
            logger.error("TimeOutException try generate payload:{}", (Object)e.getMessage());
            return new Result(State.VULNERABLE, 0, "");
        }
        if (payloads == null) {
            return new Result(State.DONT_KNOW, 0, "");
        }
        char postfix = this.getPayloadPostfix(expression);
        for (String s : payloads) {
            if (++tests > 10000) {
                logger.warn("too many sample!");
                return new Result(State.DONT_KNOW, 10000, "");
            }
            String payload = s + postfix;
            try {
                Matcher matcher = RegexUtils.getMatcherWithTimeout(payload, pattern, 1000);
                matcher.matches();
            }
            catch (TimeOutException e) {
                logger.error("TimeOutException count:{}", (Object)tests);
                return new Result(State.VULNERABLE, 0, payload);
            }
            catch (StackOverflowError e) {
                logger.error("StackOverflowError! regex: {}", (Object)pattern);
                return new Result(State.VULNERABLE, 0, payload);
            }
        }
        return new Result(State.PROBABLY_NOT_VULNERABLE, tests, "");
    }

    private char getPayloadPostfix(Expression expression) {
        char postfix = '\u0000';
        for (char ch = '!'; ch < '\uffff'; ch = (char)(ch + '\u0001')) {
            Atom postfixExpression = Atom.clone(String.valueOf(ch));
            if (!expression.intersect(postfixExpression).isEmpty()) continue;
            postfix = ch;
            break;
        }
        return postfix;
    }

    private Result fuzzStrongMode(Pattern pattern, Expression expression, int timeout) {
        Payloads payloads;
        try {
            payloads = this.getPayloadsByVaryingRepetition(expression, timeout);
        }
        catch (TimeOutException e) {
            logger.error("TimeOutException try generate payload:{}", (Object)e.getMessage());
            return new Result(State.VULNERABLE, 0, "");
        }
        char postfix = this.getPayloadPostfix(expression);
        if (this.isTimeOut(pattern, payloads, postfix)) {
            return new Result(State.VULNERABLE, 0, "");
        }
        payloads = this.getPayloadsBySimpleStrategy(expression);
        if (this.isTimeOut(pattern, payloads, postfix)) {
            return new Result(State.VULNERABLE, 0, "");
        }
        return new Result(State.PROBABLY_NOT_VULNERABLE, 0, "");
    }

    private boolean isTimeOut(Pattern pattern, Payloads payloads, char postfix) {
        if (payloads == null) {
            logger.warn("Payloads is null! regex: {}", (Object)pattern);
            return false;
        }
        int tests = 0;
        for (String s : payloads) {
            if (++tests > 10000) {
                logger.warn("Too many sample!");
                return false;
            }
            String payload = s + postfix;
            try {
                Matcher matcher = RegexUtils.getMatcherWithTimeout(payload, pattern, 1000);
                matcher.matches();
            }
            catch (TimeOutException e) {
                logger.error("TimeOutException! regex: {}, count:{}", (Object)pattern, (Object)tests);
                return true;
            }
            catch (StackOverflowError e) {
                logger.error("StackOverflowError! regex: {}, payload:{}", (Object)pattern, (Object)payload);
                return true;
            }
        }
        return false;
    }

    private Payloads getPayloadsByVaryingRepetition(Expression expression, int timeout) {
        VaryingRepetition strategy = new VaryingRepetition(100, 5000, 3000, timeout);
        return expression.payloads(strategy);
    }

    private Payloads getPayloadsBySimpleStrategy(Expression expression) {
        SimpleStrategy strategy = new SimpleStrategy();
        return expression.payloads(strategy);
    }

    public Boolean fuzz(String regex, long timeOut, TimeUnit unit, boolean strongMode) throws TimeoutException, UnKnownException {
        return this.executor.execute(() -> this.fuzzRegex(regex, strongMode), timeOut, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fuzzRegex(String regex, boolean strongMode) throws UnKnownException {
        Result result = new Result(State.DONT_KNOW, 0, "");
        try {
            result = this.parseAndFuzz(regex, -1, strongMode);
            if (State.VULNERABLE.equals((Object)result.state())) {
                boolean bl = true;
                return bl;
            }
            if (State.PROBABLY_NOT_VULNERABLE.equals((Object)result.state()) || State.NOT_VULNERABLE.equals((Object)result.state())) {
                boolean bl = false;
                return bl;
            }
            if (State.DONT_KNOW.equals((Object)result.state())) {
                throw new UnKnownException("Cannot tell whether this expression is vulnerable or not.");
            }
        }
        catch (PatternSyntaxException e) {
            logger.error("An error occurred when check the pattern.", (Throwable)e);
        }
        finally {
            logger.debug("Testing:[{}] ;result:[{}]", (Object)regex, (Object)result);
        }
        return false;
    }
}

