/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions;

import com.huawei.us.common.regexfuzzer.expressions.Atom;
import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.expressions.Option;
import com.huawei.us.common.regexfuzzer.expressions.Optional;
import com.huawei.us.common.regexfuzzer.expressions.Sequence;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.Strategy;
import java.util.Locale;
import java.util.Set;

public class RecursiveRepetition
implements Expression {
    protected static final int DEFAULT_MAX_REPETITION = 45;
    private final Expression expression;
    private final int start;
    private final int end;
    private final Expression substitution;

    public RecursiveRepetition(Expression expression, int start, int end) {
        this.expression = expression;
        this.start = start;
        this.end = end;
        this.substitution = this.substitute(expression, start, end);
    }

    public static RecursiveRepetition clone(Expression expression, int size) {
        return new RecursiveRepetition(expression, size, size);
    }

    public static RecursiveRepetition clone(Expression expression, int start, int end) {
        return new RecursiveRepetition(expression, start, end);
    }

    protected static Expression sequence(Expression expression, int times) {
        Expression exp = Atom.EMPTY;
        for (int i = 0; i < times; ++i) {
            exp = Sequence.clone(exp, expression);
        }
        return exp.simplify();
    }

    protected static Expression options(Expression expression, int times) {
        Expression exp = Atom.EMPTY;
        for (int i = times; i >= 0; --i) {
            exp = Option.clone(RecursiveRepetition.sequence(expression, i), exp);
        }
        return exp.simplify();
    }

    protected Expression substitute(Expression expression, int start, int end) {
        int newEnd = Math.min(end, 45);
        Expression newExpression = expression.simplify();
        if (newEnd < start) {
            throw new IllegalArgumentException();
        }
        if (newEnd == start) {
            return RecursiveRepetition.sequence(newExpression, start);
        }
        if (start == 0) {
            return Optional.clone(RecursiveRepetition.options(newExpression, newEnd - start)).simplify();
        }
        return Sequence.clone(RecursiveRepetition.sequence(newExpression, start - 1), RecursiveRepetition.options(newExpression, newEnd - start + 1)).simplify();
    }

    @Override
    public Expression intersect(Expression recursiverepetition) {
        return this.substitution.intersect(recursiverepetition);
    }

    @Override
    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @Override
    public Expression.Match matchAt(int index, char ch) {
        return this.substitution.matchAt(index, ch);
    }

    @Override
    public Set<Integer> lengthOptions() {
        return this.substitution.lengthOptions();
    }

    @Override
    public Payloads payloads(Strategy strategy) {
        return strategy.repetition(this.expression.payloads(strategy), this.substitution.payloads(strategy), this.start, this.end);
    }

    public String toString() {
        if (this.end == Integer.MAX_VALUE) {
            return String.format(Locale.ENGLISH, "(%s){%d,}", this.expression, this.start);
        }
        if (this.start == this.end) {
            return String.format(Locale.ENGLISH, "(%s){%d}", this.expression, this.start);
        }
        return String.format(Locale.ENGLISH, "(%s){%d,%d}", this.expression, this.start, this.end);
    }

    public Expression substitution() {
        return this.substitution;
    }

    @Override
    public Expression simplify() {
        if (this.expression.isEmpty()) {
            return this.expression;
        }
        return this;
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof Expression) {
            obj = ((Expression)obj).simplify();
        }
        if (obj instanceof RecursiveRepetition) {
            RecursiveRepetition recursiverepetition = (RecursiveRepetition)obj;
            return this.expression.equals(recursiverepetition.expression) && this.start == recursiverepetition.start && this.end == recursiverepetition.end;
        }
        return this.substitution.equals(obj);
    }

    public int hashCode() {
        Expression self = this.simplify();
        if (self instanceof RecursiveRepetition) {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.expression.hashCode();
            hashCode = 31 * hashCode + this.start;
            hashCode = 31 * hashCode + this.end;
            return hashCode;
        }
        return self.hashCode();
    }
}

