/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions;

import com.huawei.us.common.regexfuzzer.expressions.Atom;
import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.Strategy;
import java.util.HashSet;
import java.util.Set;

public class Sequence
implements Expression {
    private final Expression head;
    private final Expression tail;

    public Sequence(Expression expa, Expression expb) {
        this.head = expa.simplify();
        this.tail = expb.simplify();
    }

    public static Sequence clone(Expression expa, Expression expb) {
        return new Sequence(expa, expb);
    }

    @Override
    public boolean isEmpty() {
        return this.head.isEmpty() && this.tail.isEmpty();
    }

    @Override
    public Expression intersect(Expression other) {
        return this.tail.intersect(other);
    }

    @Override
    public Expression.Match matchAt(int index, char ch) {
        Expression.Match matchA = this.head.matchAt(index, ch);
        if (!Expression.Match.OUT_OF_RANGE.equals((Object)matchA)) {
            return matchA;
        }
        Expression.Match bestMatch = Expression.Match.OUT_OF_RANGE;
        for (int length : this.head.lengthOptions()) {
            Expression.Match match = this.tail.matchAt(index - length, ch);
            if (Expression.Match.MATCH.equals((Object)match)) {
                return Expression.Match.MATCH;
            }
            if (!Expression.Match.NO_MATCH.equals((Object)match)) continue;
            bestMatch = Expression.Match.NO_MATCH;
        }
        return bestMatch;
    }

    @Override
    public Set<Integer> lengthOptions() {
        HashSet<Integer> lengths = new HashSet<Integer>();
        for (int lengthA : this.head.lengthOptions()) {
            for (int lengthB : this.tail.lengthOptions()) {
                lengths.add(lengthA + lengthB);
            }
        }
        return lengths;
    }

    @Override
    public Payloads payloads(Strategy strategy) {
        return strategy.sequence(this.head.payloads(strategy), this.tail.payloads(strategy));
    }

    public String toString() {
        return this.head.toString() + this.tail.toString();
    }

    @Override
    public Expression simplify() {
        if (this.head.isEmpty()) {
            return this.tail;
        }
        if (this.tail.isEmpty()) {
            return this.head;
        }
        if (this.head instanceof Atom && this.tail instanceof Atom) {
            return Atom.clone(this.head.toString() + this.tail.toString());
        }
        return this;
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Expression) {
            object = ((Expression)object).simplify();
        }
        if (object instanceof Sequence) {
            Sequence sequence = (Sequence)object;
            return this.head.equals(sequence.head) && this.tail.equals(sequence.tail);
        }
        Expression expression = this.simplify();
        if (expression instanceof Sequence) {
            return false;
        }
        return expression.equals(object);
    }

    public int hashCode() {
        Expression expression = this.simplify();
        if (expression instanceof Sequence) {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.head.hashCode();
            hashCode = 31 * hashCode + this.tail.hashCode();
            return hashCode;
        }
        return expression.hashCode();
    }
}

