/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions.character;

import com.huawei.us.common.regexfuzzer.expressions.Atom;
import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.expressions.Option;
import com.huawei.us.common.regexfuzzer.expressions.character.CharacterSet;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.Strategy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class CharacterClass
implements Expression {
    private final CharacterSet set;
    private final boolean including;

    public CharacterClass(CharacterSet set, boolean inclusive) {
        this.set = set;
        this.including = inclusive;
    }

    public static CharacterClass including(CharacterSet set) {
        return new CharacterClass(set, true);
    }

    public static CharacterClass including(String str) {
        return new CharacterClass(CharacterSet.clone(str), true);
    }

    public static CharacterClass excluding(CharacterSet set) {
        return new CharacterClass(set, false);
    }

    public static CharacterClass excluding(String str) {
        return new CharacterClass(CharacterSet.clone(str), false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (!this.including) {
            sb.append("^");
        }
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            char ch = ((Character)iterator.next()).charValue();
            sb.append(ch);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Expression intersect(Expression characterclass) {
        Expression expression = Atom.EMPTY;
        if (!this.including) {
            boolean find = false;
            char temp = '\u0000';
            Iterator iterator = this.set.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                Expression.Match match = characterclass.matchAt(0, ch);
                if (!Expression.Match.MATCH.equals((Object)match)) continue;
                find = true;
                temp = ch;
                break;
            }
            if (!find) {
                expression = Option.clone(Atom.clone(String.valueOf(temp)), expression);
            }
        } else {
            Iterator iterator = this.set.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                Expression.Match match = characterclass.matchAt(0, ch);
                if (Expression.Match.MATCH.equals((Object)match)) {
                    expression = Option.clone(Atom.clone(String.valueOf(ch)), expression);
                    continue;
                }
                if (!match.equals((Object)Expression.Match.OUT_OF_RANGE)) continue;
                return Atom.EMPTY;
            }
        }
        return expression.simplify();
    }

    @Override
    public boolean isEmpty() {
        return this.including && this.set.isEmpty();
    }

    @Override
    public Expression.Match matchAt(int index, char ch) {
        if (index < Collections.max(this.lengthOptions())) {
            return this.including == this.set.contains(Character.valueOf(ch)) ? Expression.Match.MATCH : Expression.Match.NO_MATCH;
        }
        return Expression.Match.OUT_OF_RANGE;
    }

    @Override
    public Payloads payloads(Strategy strategy) {
        return strategy.characterClass(this.set, this.including);
    }

    @Override
    public Set<Integer> lengthOptions() {
        return Collections.singleton(1);
    }

    @Override
    public Expression simplify() {
        if (this.isEmpty()) {
            return Atom.EMPTY;
        }
        if (this.set.size() == 1 && this.including) {
            return Atom.clone(String.valueOf(this.set.iterator().next()));
        }
        return this;
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof Expression) {
            obj = ((Expression)obj).simplify();
        }
        if (obj instanceof CharacterClass) {
            CharacterClass character = (CharacterClass)obj;
            return this.including == character.including && this.set.equals(character.set);
        }
        Expression expression = this.simplify();
        if (expression instanceof CharacterClass) {
            return false;
        }
        return expression.equals(obj);
    }

    public int hashCode() {
        Expression expression = this.simplify();
        if (expression instanceof CharacterClass) {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.set.hashCode();
            hashCode = 31 * hashCode + (this.including ? 1 : 0);
            return hashCode;
        }
        return expression.hashCode();
    }

    public CharacterSet toSet() {
        if (this.including) {
            return this.set;
        }
        return this.set.inverted();
    }
}

