/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions.character;

import java.util.HashSet;

public class CharacterSet
extends HashSet<Character> {
    private static final long serialVersionUID = -130051111331855947L;

    public CharacterSet(int initialCapacity) {
        super(initialCapacity);
    }

    public static CharacterSet clone(String chars) {
        CharacterSet set = new CharacterSet(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            set.add(Character.valueOf(chars.charAt(i)));
        }
        return set;
    }

    public static CharacterSet clone(char from, char to) {
        if (to < from) {
            throw new IllegalArgumentException();
        }
        CharacterSet set = new CharacterSet(to - from + 1);
        for (int i = from; i <= to; ++i) {
            set.add(Character.valueOf((char)i));
        }
        return set;
    }

    public static CharacterSet getDigits() {
        return CharacterSet.clone('0', '9');
    }

    public static CharacterSet getWords() {
        CharacterSet word = CharacterSet.getDigits();
        word.addAll(CharacterSet.clone('A', 'Z'));
        word.addAll(CharacterSet.clone('a', 'z'));
        word.add(Character.valueOf('_'));
        return word;
    }

    public static CharacterSet getWhiteSpace() {
        return CharacterSet.clone(" \t\r\n\f\u000b\u001c\u001d\u001f\u001e");
    }

    public static CharacterSet getLineBreaks() {
        return CharacterSet.clone("\r\n");
    }

    public CharacterSet inverted() {
        CharacterSet inverse = new CharacterSet(128 - this.size());
        for (int i = 0; i < 128; ++i) {
            if (this.contains(Character.valueOf((char)i))) continue;
            inverse.add(Character.valueOf((char)i));
        }
        return inverse;
    }
}

