/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.parser;

import com.huawei.us.common.regexfuzzer.expressions.character.CharacterClass;
import com.huawei.us.common.regexfuzzer.expressions.character.CharacterSet;
import com.huawei.us.common.regexfuzzer.expressions.character.ExcludingDigit;
import com.huawei.us.common.regexfuzzer.expressions.character.ExcludingWhiteSpace;
import com.huawei.us.common.regexfuzzer.expressions.character.ExcludingWord;
import com.huawei.us.common.regexfuzzer.expressions.character.IncludingDigit;
import com.huawei.us.common.regexfuzzer.expressions.character.IncludingWhiteSpace;
import com.huawei.us.common.regexfuzzer.expressions.character.IncludingWord;
import com.huawei.us.common.regexfuzzer.parser.EscapeCharacterParser;
import com.huawei.us.common.regexfuzzer.parser.Regex;

public class CharacterClassParser {
    private CharacterClassParser() {
        throw new IllegalStateException("Utility class");
    }

    public static CharacterClass parse(Regex regex) {
        CharacterSet characters = new CharacterSet(regex.length());
        boolean including = CharacterClassParser.parseIncluding(regex);
        do {
            if (regex.isEmpty()) {
                regex.error("Missing ']' at the end of character class.");
            }
            if (regex.startWith('\\')) {
                if (CharacterClassParser.isCharacter(regex)) {
                    CharacterSet subset = CharacterClassParser.predefinedCharacterClass(regex).toSet();
                    characters.addAll(including ? subset : subset.inverted());
                    continue;
                }
                characters.add(Character.valueOf(EscapeCharacterParser.unescapeCurrent(regex)));
                continue;
            }
            if (CharacterClassParser.isRange(regex)) {
                characters.addAll(CharacterClassParser.parseRange(regex));
                continue;
            }
            characters.add(Character.valueOf(regex.consumeNextChar()));
        } while (!regex.startWith("]"));
        regex.consumeToken("]");
        return new CharacterClass(characters, including);
    }

    public static boolean isCharacter(Regex regex) {
        return regex.length() > 1 && "dwsDWS".indexOf(regex.charAt(1)) != -1;
    }

    public static boolean isRange(Regex regex) {
        return regex.length() >= 3 && (Character.isDigit(regex.charAt(0)) || Character.isLetter(regex.charAt(0))) && regex.charAt(1) == '-';
    }

    public static boolean parseIncluding(Regex regex) {
        boolean including = true;
        if (regex.startWith("[^")) {
            including = false;
            regex.consumeToken("[^");
        } else if (regex.startWith("[:")) {
            regex.error("Posix character classes are not implemented yet. [:digit:] etc.");
        } else if (regex.startWith("[")) {
            regex.consumeToken("[");
        } else {
            regex.error("Missing [ at the beginning of a character class");
        }
        return including;
    }

    private static CharacterSet parseRange(Regex regex) {
        char from = regex.consumeNextChar();
        regex.consumeToken("-");
        char to = regex.consumeNextChar();
        if (from >= to) {
            regex.error("Invalid character range " + from + "-" + to);
        }
        return CharacterSet.clone(from, to);
    }

    static CharacterClass predefinedCharacterClass(Regex regex) {
        regex.consumeToken("\\");
        char ch = regex.consumeNextChar();
        switch (ch) {
            case 'd': {
                return new IncludingDigit();
            }
            case 'D': {
                return new ExcludingDigit();
            }
            case 'w': {
                return new IncludingWord();
            }
            case 'W': {
                return new ExcludingWord();
            }
            case 's': {
                return new IncludingWhiteSpace();
            }
            case 'S': {
                return new ExcludingWhiteSpace();
            }
        }
        throw new IllegalStateException("Unknown predefined character class \\" + ch);
    }
}

