/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.parser;

import com.huawei.us.common.regexfuzzer.expressions.Atom;
import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.expressions.Option;
import com.huawei.us.common.regexfuzzer.expressions.Optional;
import com.huawei.us.common.regexfuzzer.expressions.Sequence;
import com.huawei.us.common.regexfuzzer.expressions.character.CharacterClass;
import com.huawei.us.common.regexfuzzer.expressions.character.ExcludingLineBreaks;
import com.huawei.us.common.regexfuzzer.parser.CharacterClassParser;
import com.huawei.us.common.regexfuzzer.parser.EscapeCharacterParser;
import com.huawei.us.common.regexfuzzer.parser.Regex;
import com.huawei.us.common.regexfuzzer.parser.RepetitionParser;

public class RegexParser {
    private Regex regex;
    private Expression root;
    private Expression current;

    public RegexParser(String str) {
        this(new Regex(str));
    }

    public RegexParser(Regex regex) {
        this.regex = regex;
        this.root = Atom.EMPTY;
        this.current = Atom.EMPTY;
    }

    public Expression getResult() {
        this.parse(0);
        return this.root;
    }

    private Expression parse(int depth) {
        StringBuilder temp = new StringBuilder();
        while (!this.regex.isEmpty()) {
            char ch = this.regex.charAt(0);
            if (ch == '\\') {
                this.backspace(temp);
            } else if (ch == '.') {
                this.regex.consumeToken(".");
                this.append(temp);
                this.append(new ExcludingLineBreaks());
            } else if (ch == '[') {
                this.append(temp);
                this.append(CharacterClassParser.parse(this.regex));
            } else if (ch == '?') {
                this.optional(temp);
            } else if (ch == '|') {
                this.option(temp, depth);
            } else if (ch == '(') {
                this.group(temp, depth);
            } else if (ch == ')') {
                this.regex.consumeToken(")");
                if (depth == 0) {
                    this.regex.error("Missing opening parantheses");
                }
            } else if (ch == '^' || ch == '$') {
                this.regex.consumeNextChar();
            } else if (ch == '*' || ch == '+' || ch == '{') {
                this.repetition(temp);
            } else {
                this.regex.consumeNextChar();
                temp.append(ch);
            }
            if (ch != ')') continue;
            break;
        }
        this.append(temp);
        this.flush();
        return this.root;
    }

    private void backspace(StringBuilder result) {
        char ch;
        if (this.regex.length() < 2) {
            this.regex.error("Premature end of expression after \\");
        }
        if ("dwsDWS".indexOf(ch = this.regex.charAt(1)) != -1) {
            CharacterClass charClass = CharacterClassParser.predefinedCharacterClass(this.regex);
            this.append(result);
            this.append(charClass);
        } else if ("bB".indexOf(ch) != -1) {
            this.regex.consumeNextChar();
            this.regex.error("Word boundary are not implemented yet!");
        } else if (ch >= '1' && ch <= '9') {
            this.regex.consumeNextChar();
            this.regex.error("Backreference (\\1 through \\9) are not supported yet!");
        } else {
            result.append(EscapeCharacterParser.unescapeCurrent(this.regex));
        }
    }

    private void optional(StringBuilder result) {
        if (!this.regex.isEmpty() && this.regex.startWith('?')) {
            this.regex.consumeToken("?");
        }
        if (result.length() == 0) {
            Expression operand = this.current;
            this.current = Optional.clone(operand);
            if ((operand = this.current).isEmpty()) {
                operand = this.root;
            }
            this.current = Optional.clone(operand);
        } else {
            Expression operand = this.getLastCharaterAsExpression(result);
            this.append(Optional.clone(operand));
        }
    }

    private Expression getLastCharaterAsExpression(StringBuilder strBuilder) {
        int mostIndex = strBuilder.length() - 1;
        char ch = strBuilder.charAt(mostIndex);
        strBuilder.setLength(mostIndex);
        Atom operand = Atom.clone(String.valueOf(ch));
        this.append(Atom.clone(strBuilder.toString()));
        strBuilder.setLength(0);
        return operand;
    }

    private void option(StringBuilder result, int depth) {
        this.regex.consumeToken("|");
        if (result.length() >= 0) {
            this.append(result);
        }
        this.flush();
        Expression operand = this.root;
        RegexParser parser = new RegexParser(this.regex);
        this.root = Option.clone(operand, parser.parse(depth));
        this.current = Atom.EMPTY;
    }

    private void group(StringBuilder result, int depth) {
        if (this.regex.startWith("(?:")) {
            this.regex.consumeToken("(?:");
        } else {
            this.regex.consumeToken("(");
        }
        if (!this.regex.isEmpty() && this.regex.charAt(0) == '?') {
            this.regex.error("Advanced syntax (expressions starting with '(?') is not yet supported");
        }
        if (result.length() >= 0) {
            this.append(result);
        }
        RegexParser parser = new RegexParser(this.regex);
        this.append(parser.parse(depth + 1));
    }

    private void repetition(StringBuilder result) {
        if (result.length() == 0) {
            Expression operand = this.current;
            if (!operand.isEmpty()) {
                this.current = RepetitionParser.parseRepetition(this.regex, operand);
            } else {
                operand = this.root;
                this.root = RepetitionParser.parseRepetition(this.regex, operand);
                this.current = Atom.EMPTY;
            }
        } else {
            Expression operand = this.getLastCharaterAsExpression(result);
            Expression repetition = RepetitionParser.parseRepetition(this.regex, operand);
            this.append(repetition);
        }
    }

    public void append(Expression expression) {
        this.flush();
        this.current = expression;
    }

    public void append(StringBuilder result) {
        this.append(Atom.clone(result.toString()));
        result.setLength(0);
    }

    public void flush() {
        this.root = Sequence.clone(this.root, this.current).simplify();
        this.current = Atom.EMPTY;
    }
}

