/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.parser;

import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.expressions.IterativeRepetition;
import com.huawei.us.common.regexfuzzer.parser.Regex;

public class RepetitionParser {
    private RepetitionParser() {
        throw new IllegalStateException("Not Support");
    }

    public static Expression parseRepetition(Regex regex, Expression expression) {
        Expression repetition;
        char ch = regex.consumeNextChar();
        switch (ch) {
            case '+': {
                repetition = IterativeRepetition.clone(expression, 1, Integer.MAX_VALUE);
                break;
            }
            case '*': {
                repetition = IterativeRepetition.clone(expression, 0, Integer.MAX_VALUE);
                break;
            }
            case '{': {
                repetition = RepetitionParser.repetitionInBraces(expression, regex);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown repetition " + ch);
            }
        }
        if (!regex.isEmpty() && regex.startWith('?')) {
            regex.consumeToken("?");
        }
        return repetition;
    }

    private static Expression repetitionInBraces(Expression operand, Regex regex) {
        if (regex.length() < 2) {
            regex.error("Premature end of repetition '" + regex.consumeAll() + "'");
        }
        regex.consumeWhiteSpace();
        int from = RepetitionParser.parseInteger(regex);
        RepetitionParser.checkPositiveInteger(regex, from);
        regex.consumeWhiteSpace();
        int to = from;
        if (regex.charAt(0) == ',') {
            regex.consumeToken(",");
            regex.consumeWhiteSpace();
            to = RepetitionParser.parseInteger(regex);
        }
        RepetitionParser.consumeClosingBrace(regex);
        if (to > 0) {
            return IterativeRepetition.clone(operand, from, to);
        }
        return IterativeRepetition.clone(operand, from, Integer.MAX_VALUE);
    }

    private static void checkPositiveInteger(Regex regex, int i) {
        if (i == -1) {
            regex.error("Error in repetition: Number expected");
        }
    }

    private static void consumeClosingBrace(Regex regex) {
        regex.consumeWhiteSpace();
        if (regex.charAt(0) != '}') {
            regex.error("Error in repetition: Missing }");
        }
        regex.consumeToken("}");
    }

    private static int parseInteger(Regex regex) {
        StringBuilder number = new StringBuilder();
        while (!regex.isEmpty() && ",} ".indexOf(regex.charAt(0)) == -1) {
            char ch = regex.consumeNextChar();
            if (ch >= '0' && ch <= '9') {
                number.append(ch);
                continue;
            }
            regex.error("Error in repetition: Number expected but got " + ch);
        }
        if (number.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(number.toString());
        }
        catch (NumberFormatException e) {
            regex.error("Error in repetition: Invalid number", e);
            return -1;
        }
    }
}

