/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.payloads;

import com.huawei.us.common.regexfuzzer.expressions.character.CharacterSet;
import com.huawei.us.common.regexfuzzer.payloads.PayloadFormatter;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CharacterPayloads
implements Payloads {
    private final char[] characters;
    private int size = 0;

    public CharacterPayloads(CharacterSet characters, boolean inclusive) {
        if (characters.isEmpty()) {
            this.characters = new char[0];
        } else if (inclusive) {
            this.characters = new char[characters.size()];
            Iterator iterator = characters.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                this.addPayloadsIncluding(ch);
            }
        } else {
            this.characters = new char[128 - characters.size()];
            this.addPayloadsExcluding(characters);
        }
    }

    public CharacterPayloads(String str) {
        this.characters = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            this.addPayloadsIncluding(str.charAt(i));
        }
    }

    private void addPayloadsExcluding(CharacterSet set) {
        for (char c = '!'; c < '\u0080'; c = (char)(c + '\u0001')) {
            if (set.contains(Character.valueOf(c))) continue;
            this.addPayloadsIncluding(c);
        }
    }

    private void addPayloadsIncluding(char ch) {
        if (this.size == this.characters.length) {
            return;
        }
        this.characters[this.size++] = ch;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new CharacterPayloadsIterator(this.characters, this.size());
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return PayloadFormatter.format(this);
    }

    private static class CharacterPayloadsIterator
    implements Iterator<String> {
        private final char[] characters;
        private final int size;
        private int index = 0;

        CharacterPayloadsIterator(char[] characters, int size) {
            this.characters = characters;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return String.valueOf(this.characters[this.index++]);
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

