/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.payloads;

import com.huawei.us.common.regexfuzzer.payloads.PayloadFormatter;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OptionPayloads
implements Payloads {
    private final Payloads sa;
    private final Payloads sb;

    public OptionPayloads(Payloads sa, Payloads sb) {
        this.sa = sa;
        this.sb = sb;
    }

    @Override
    public boolean isEmpty() {
        return this.sa.isEmpty() && this.sb.isEmpty();
    }

    @Override
    public int size() {
        return Math.min(this.sa.size() + this.sb.size(), Integer.MAX_VALUE);
    }

    @Override
    public Iterator<String> iterator() {
        return new OptionIterator(this.sa, this.sb);
    }

    public String toString() {
        return PayloadFormatter.format(this);
    }

    private static class OptionIterator
    implements Iterator<String> {
        private final Iterator<String> payloadsA;
        private final Iterator<String> payloadsB;

        OptionIterator(Payloads sa, Payloads sb) {
            this.payloadsA = sa.iterator();
            this.payloadsB = sb.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.payloadsA.hasNext() || this.payloadsB.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.payloadsA.hasNext()) {
                return this.payloadsA.next();
            }
            return this.payloadsB.next();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

