/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.payloads;

import com.huawei.us.common.regexfuzzer.payloads.PayloadFormatter;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RepetitionPayloads
implements Payloads {
    private final Payloads payloads;
    private final int start;
    private final int end;

    public RepetitionPayloads(Payloads payloads, int start, int end) {
        this.start = start;
        this.payloads = payloads;
        this.end = end;
    }

    @Override
    public Iterator<String> iterator() {
        return new RepetitionIterator(this.payloads, this.start, this.end);
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.start == 0 && this.end == 0;
    }

    public String toString() {
        return PayloadFormatter.format(this);
    }

    private static class RepetitionIterator
    implements Iterator<String> {
        private final Payloads payloads;
        private final int start;
        private final int end;
        private Iterator<String> elements;
        private int count;

        RepetitionIterator(Payloads payloads, int start, int end) {
            this.start = start;
            this.end = end;
            this.payloads = payloads;
            this.elements = payloads.iterator();
            this.count = 0;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String elementPayload = this.elements.next();
            StringBuilder payloadBuilder = new StringBuilder(this.start + this.count);
            for (int i = 0; i < this.start + this.count; ++i) {
                payloadBuilder.append(elementPayload);
            }
            if (!this.elements.hasNext() || payloadBuilder.length() == 0) {
                this.elements = this.payloads.iterator();
                ++this.count;
            }
            return payloadBuilder.toString();
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext() && this.start + this.count <= this.end;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

