/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.strategy;

import com.huawei.us.common.regexfuzzer.expressions.character.CharacterSet;
import com.huawei.us.common.regexfuzzer.payloads.AtomPayloads;
import com.huawei.us.common.regexfuzzer.payloads.CharacterPayloads;
import com.huawei.us.common.regexfuzzer.payloads.PayloadHashSet;
import com.huawei.us.common.regexfuzzer.payloads.PayloadSet;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.Strategy;
import com.huawei.us.common.regexfuzzer.utils.TimeOutException;

public class FixedRepetition
extends Strategy {
    private static final int DEFAULT_MAX_REPETITION_SIZE = 30;
    private static final int DEFAULT_MAX_SAMPLE_LENGTH = 1000;
    private static final int DEFAULT_MAX_NUMBER_OF_SAMPLES = 5000;
    protected static final int DEFAULT_TIMEOUT = -1;
    private final int maxRepetitionSize;
    private final int maxPayloadLength;
    private final int maxNumberOfPayloads;

    public FixedRepetition(int maxRepetitionSize, int maxPayloadLength, int maxNumberOfPayloads) {
        this(maxRepetitionSize, maxPayloadLength, maxNumberOfPayloads, System.currentTimeMillis(), -1);
    }

    public FixedRepetition(int maxRepetitionSize, int maxPayloadLength, int maxNumberOfPayloads, long current, int timeout) {
        this.maxRepetitionSize = maxRepetitionSize;
        this.maxPayloadLength = maxPayloadLength;
        this.maxNumberOfPayloads = maxNumberOfPayloads;
        this.current = current;
        this.timeout = timeout;
    }

    public FixedRepetition() {
        this(30, 1000, 5000, System.currentTimeMillis(), -1);
    }

    @Override
    public Payloads atom(String pattern) {
        return new AtomPayloads(pattern);
    }

    @Override
    public Payloads characterClass(CharacterSet characterSet, boolean inclusive) {
        return new CharacterPayloads(characterSet, inclusive);
    }

    @Override
    public Payloads optional(Payloads payloads) {
        PayloadSet payloadSet = PayloadHashSet.clone(this.maxNumberOfPayloads, payloads);
        payloadSet.add("");
        return payloadSet;
    }

    @Override
    public Payloads option(Payloads payloadA, Payloads payloadB) {
        return new PayloadHashSet(this.maxNumberOfPayloads, payloadA, payloadB);
    }

    @Override
    public Payloads repetition(Payloads elementPayloads, Payloads substitutionPayloads, int start, int end) {
        int repetitions = Math.min(end, this.maxRepetitionSize);
        int size = elementPayloads.size() * repetitions;
        PayloadHashSet payloadSet = new PayloadHashSet(size, this.maxNumberOfPayloads);
        for (String payload : elementPayloads) {
            if (payloadSet.isFull()) break;
            StringBuilder builder = new StringBuilder(repetitions);
            for (int i = 0; i < repetitions; ++i) {
                builder.append(payload);
            }
            payloadSet.add(builder.toString());
        }
        return payloadSet;
    }

    private boolean isTimeout() {
        if (this.timeout <= 0) {
            return false;
        }
        return System.currentTimeMillis() - this.current >= (long)this.timeout * 1000L;
    }

    @Override
    public Payloads sequence(Payloads head, Payloads tail) {
        PayloadHashSet payloadSet = new PayloadHashSet(head.size() * tail.size(), this.maxNumberOfPayloads);
        block0: for (String headPayload : head) {
            for (String tailPayload : tail) {
                if (this.isTimeout()) {
                    throw new TimeOutException();
                }
                if (payloadSet.isFull() || headPayload.length() + tailPayload.length() > this.maxPayloadLength || headPayload.length() == 0) continue block0;
                payloadSet.add(headPayload + tailPayload);
            }
        }
        return payloadSet;
    }
}

