/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.utils;

import com.huawei.us.common.regexfuzzer.utils.TimeOutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    private RegexUtils() {
    }

    public static Matcher getMatcherWithTimeout(String toMatch, Pattern pattern, int timeoutMillis) {
        TimeoutRegexCharSequence charSequence = new TimeoutRegexCharSequence(toMatch, toMatch, pattern.pattern(), timeoutMillis);
        return pattern.matcher(charSequence);
    }

    private static class TimeoutRegexCharSequence
    implements CharSequence {
        private final CharSequence inner;
        private final int timeout;
        private final long start;
        private final String toMatch;
        private final String regex;

        public TimeoutRegexCharSequence(CharSequence inner, String toMatch, String regex, int timeoutMillis) {
            this.inner = inner;
            this.timeout = timeoutMillis;
            this.toMatch = toMatch;
            this.regex = regex;
            this.start = System.currentTimeMillis();
        }

        @Override
        public char charAt(int index) {
            if (System.currentTimeMillis() - this.start > (long)this.timeout) {
                throw new TimeOutException("Regex Match Timeout occurred, " + this.regex + "' on input '" + this.toMatch + "'!");
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TimeoutRegexCharSequence(this.inner.subSequence(start, end), this.toMatch, this.regex, this.timeout);
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }
}

