/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.resource;

import com.huawei.us.common.resource.ResourceUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfigUtil {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfigUtil.class);
    private static Map<String, String> usConfigMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> usConfigMapExt = new ConcurrentHashMap<String, String>();
    private static boolean MONITOR_SWITCH = true;

    public static String getStringValueByName(String key, String defValue) {
        String value;
        if (usConfigMap.size() == 0) {
            usConfigMap.putAll(ResourceUtil.getPropertiesAsMap());
            SystemConfigUtil.loadUsConfigMapExt();
        }
        if ((value = usConfigMap.get(key)) == null) {
            return defValue;
        }
        return value;
    }

    private static void monitor() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (MONITOR_SWITCH) {
                        Thread.sleep(600000L);
                        logger.debug("refresh us config start...");
                        usConfigMap.putAll(ResourceUtil.getPropertiesAsMap());
                        SystemConfigUtil.loadUsConfigMapExt();
                        logger.debug("refresh us config success...");
                        logger.debug(SystemConfigUtil.getStringValueByName("us.aop.log.kind", "default"));
                        logger.debug("refresh us config end...");
                    }
                }
                catch (Throwable e) {
                    logger.debug("refresh us config cache failed", e);
                    continue;
                }
                break;
            }
        }, "properties-monitor-thread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((thd, exc) -> logger.error(thd.getName() + " : " + exc.getMessage()));
        thread.start();
    }

    public static void reloadAllConfig() {
        logger.debug("reloadAllConfig us config start...");
        usConfigMap.putAll(ResourceUtil.getPropertiesAsMap());
        SystemConfigUtil.loadUsConfigMapExt();
        logger.debug("reloadAllConfig us config end...");
    }

    public static void closeMonitor() {
        MONITOR_SWITCH = false;
    }

    public static void overrideUsConfig(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String mapKey = entry.getKey();
            String mapValue = entry.getValue();
            if (usConfigMap.containsKey(mapKey)) {
                logger.debug("overwrite us config: {}", (Object)mapKey);
            } else {
                logger.debug("add new us config: {}", (Object)mapKey);
            }
            usConfigMapExt.put(mapKey, mapValue);
        }
        SystemConfigUtil.loadUsConfigMapExt();
    }

    public static void clearUsConfigMapExt() {
        usConfigMapExt.clear();
        SystemConfigUtil.reloadAllConfig();
    }

    private static void loadUsConfigMapExt() {
        if (usConfigMapExt.size() > 0) {
            usConfigMap.putAll(usConfigMapExt);
        }
    }

    static {
        usConfigMap.putAll(ResourceUtil.getPropertiesAsMap());
        SystemConfigUtil.loadUsConfigMapExt();
        SystemConfigUtil.monitor();
    }
}

