/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.sensitive;

import com.huawei.us.common.sensitive.Anonymization;
import com.huawei.us.common.sensitive.impl.AnonymizationForEmail;
import com.huawei.us.common.sensitive.impl.AnonymizationForIdCard;
import com.huawei.us.common.sensitive.impl.AnonymizationForName;
import com.huawei.us.common.sensitive.impl.AnonymizationForPhone;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymizationUtils {
    private static final Logger logger = LoggerFactory.getLogger(AnonymizationUtils.class);

    public static String anonymization(String type, String origin) {
        if (Anonymization.INSTANCES.containsKey(type)) {
            return Anonymization.INSTANCES.get(type).anonymizationExec(origin);
        }
        logger.error("nonsupport anonymization type: {}", (Object)type);
        throw new InvalidParameterException("nonsupport anonymization type: " + type);
    }

    public static String left(String str, int index) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        String name = StringUtils.left((String)str, (int)index);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)str), (String)"*");
    }

    public static String around(String str, int index, int end) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return StringUtils.left((String)str, (int)index).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)str, (int)end), (int)StringUtils.length((CharSequence)str), (String)"*"), (String)"***"));
    }

    public static String right(String str, int end) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)str, (int)end), (int)StringUtils.length((CharSequence)str), (String)"*");
    }

    static {
        Anonymization.INSTANCES.put("email", new AnonymizationForEmail());
        Anonymization.INSTANCES.put("idCard", new AnonymizationForIdCard());
        Anonymization.INSTANCES.put("name", new AnonymizationForName());
        Anonymization.INSTANCES.put("phone", new AnonymizationForPhone());
    }
}

