/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.sqlinjection.thread;

import com.huawei.us.common.regexfuzzer.executor.DaemonThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CheckerExecutor {
    private final ExecutorService service;
    private final long timeout;
    private final TimeUnit unit;

    private CheckerExecutor(ExecutorService service, long timeout, TimeUnit unit) {
        this.service = service;
        this.timeout = timeout;
        this.unit = unit;
    }

    public CheckerExecutor() {
        this(Executors.newFixedThreadPool(60, new DaemonThreadFactory()), 1L, TimeUnit.SECONDS);
    }

    public <T> T execute(Callable<T> task, ExceptionMapper handler) {
        Future<T> result = this.service.submit(task);
        try {
            return result.get(this.timeout, this.unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw handler.map(e);
        }
    }

    public static interface ExceptionMapper {
        public RuntimeException map(Exception var1);
    }
}

