/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.sqlinjection.thread;

import com.huawei.us.common.sqlinjection.check.CheckState;
import com.huawei.us.common.sqlinjection.pattern.SqlInjectionPatterns;
import com.huawei.us.common.sqlinjection.thread.CheckerExecutor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckerMatcher {
    private static final ExceptionMapper MAPPER = new ExceptionMapper();
    private static final CheckerExecutor EXECUTOR = new CheckerExecutor();

    public CheckState match(String sql, List<String> hitRule) {
        return EXECUTOR.execute(() -> {
            CheckState checkState = CheckState.NOT_INJECTED;
            for (Map.Entry<String, Pattern> entry : SqlInjectionPatterns.SQL_INJECTION_PATTERNS.entrySet()) {
                if (!entry.getValue().matcher(sql).find()) continue;
                Matcher matcher = SqlInjectionPatterns.SHIELDED_PATTERN.matcher(sql);
                if (matcher.find()) {
                    String newSqlStr = matcher.replaceAll("");
                    if (!entry.getValue().matcher(newSqlStr).find()) continue;
                    checkState = CheckState.INJECTED;
                    hitRule.add(entry.getKey());
                    continue;
                }
                checkState = CheckState.INJECTED;
                hitRule.add(entry.getKey());
            }
            return checkState;
        }, MAPPER);
    }

    protected static class ExceptionMapper
    implements CheckerExecutor.ExceptionMapper {
        protected ExceptionMapper() {
        }

        @Override
        public RuntimeException map(Exception exception) {
            if (exception instanceof ExecutionException) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new IllegalStateException(throwable);
            }
            throw new IllegalStateException(exception);
        }
    }
}

