/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.url;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UDecoder {
    private static final Logger logger = LoggerFactory.getLogger(UDecoder.class);

    UDecoder() {
    }

    static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            logger.error("[US-COMMON] URLDecoder: empty string enc parameter");
            throw new UnsupportedEncodingException("URLDecoder: empty enc parameter");
        }
        byte[] bytes = null;
        while (i < numChars) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < numChars && c == '%') {
                        int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        if (v < 0) {
                            throw new IllegalArgumentException("[US-COMMON] URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                        }
                        bytes[pos++] = (byte)v;
                        if ((i += 3) >= numChars) continue;
                        c = s.charAt(i);
                    }
                    if (i < numChars && c == '%') {
                        throw new IllegalArgumentException("[US-COMMON] URLDecoder: Incomplete trailing escape (%) pattern");
                    }
                    sb.append(new String(bytes, 0, pos, enc));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("[US-COMMON] URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                }
                needToChange = true;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }
}

