/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.core;

import com.huawei.wsf.util.EmptyUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HWValidator {
    private static final List<String> COMMAND_BLACK_LISTS = Stream.of("&&", "&", "||", "|", ";", "`", "$(", "<", ">", ">>", "<<", "!", "\\", "\n").collect(Collectors.toList());
    private static final int READ_LIMIT = 20;
    private static final int ZERO_STRING_LENGTH = 2;
    private static final Logger LOG = LoggerFactory.getLogger(HWValidator.class);

    private HWValidator() {
    }

    public static boolean isValidInput(String input, String type, int maxLength, boolean allowNull) {
        return ESAPI.validator().isValidInput("", input, type, maxLength, allowNull);
    }

    public static boolean isValidInput(String input, String type, int maxLength, boolean allowNull, boolean canonicalize) {
        return ESAPI.validator().isValidInput("", input, type, maxLength, allowNull, canonicalize);
    }

    public static boolean isValidDate(String input, DateFormat format) {
        if (EmptyUtils.isEmpty(input)) {
            return false;
        }
        return ESAPI.validator().isValidDate("", input, format, false);
    }

    public static String getValidSafeHTML(String input) {
        return HWValidator.getOptionalValidSafeHtml(input).orElse(null);
    }

    private static Optional<String> getOptionalValidSafeHtml(String input) {
        if (input == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(ESAPI.validator().getValidSafeHTML("", input, Integer.MAX_VALUE, false));
        }
        catch (ValidationException e) {
            return Optional.empty();
        }
    }

    public static String getValidSafeHTML(String input, boolean isCanonicalize) {
        return HWValidator.getOptionalValidSafeHtml(input, isCanonicalize).orElse(null);
    }

    private static Optional<String> getOptionalValidSafeHtml(String input, boolean isCanonicalize) {
        if (input == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(ESAPI.validator().getValidSafeHTML("", input, Integer.MAX_VALUE, false, isCanonicalize));
        }
        catch (ValidationException e) {
            return Optional.empty();
        }
    }

    public static boolean isValidCreditCard(String input) {
        try {
            ESAPI.validator().getValidCreditCard("", input, false);
            return true;
        }
        catch (IntrusionException | ValidationException e) {
            return false;
        }
    }

    public static boolean isValidDirectoryPath(String input, File parent) {
        return HWValidator.isValidDirectoryPath(input, parent, true);
    }

    public static boolean isValidDirectoryPath(String input, File parent, boolean needExistDir) {
        try {
            ESAPI.validator().getValidDirectoryPath("", input, parent, false, needExistDir);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    public static boolean isValidFileName(String input) {
        return HWValidator.isValidFileName(input, ESAPI.securityConfiguration().getAllowedFileExtensions());
    }

    public static boolean isValidFileName(String input, List<String> allowedFileExtensions) {
        return ESAPI.validator().isValidFileName("", input, allowedFileExtensions, false);
    }

    public static boolean isValidNumber(String input, long minValue, long maxValue) {
        try {
            ESAPI.validator().getValidNumber("", input, minValue, maxValue, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    public static boolean isValidDouble(String input, double minValue, double maxValue) {
        try {
            ESAPI.validator().getValidDouble("", input, minValue, maxValue, false);
        }
        catch (IntrusionException | ValidationException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidInteger(String input, int minValue, int maxValue) {
        try {
            ESAPI.validator().getValidInteger("", input, minValue, maxValue, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    public static boolean isSafeFileTypeForUpload(BufferedInputStream is) {
        String types = ESAPI.securityConfiguration().getPropertyValue("ESAPI.FileUpLoadAllowedTypeCode");
        return HWValidator.isSafeFileTypeForUpload(is, types);
    }

    public static boolean isSafeFileTypeForUpload(BufferedInputStream is, String allowedTypeCode) {
        String code = HWValidator.getFileTypeCode(is);
        if (code == null || EmptyUtils.isEmpty(allowedTypeCode)) {
            return false;
        }
        for (String str : allowedTypeCode.split(",")) {
            if (!code.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public static String getFileTypeCode(BufferedInputStream is) {
        return HWValidator.getOptionalFileTypeCode(is).orElse(null);
    }

    private static Optional<String> getOptionalFileTypeCode(BufferedInputStream is) {
        byte[] fileType = new byte[20];
        try {
            is.mark(20);
            int result = is.read(fileType, 0, fileType.length);
            is.reset();
            String re = null;
            if (result == 20) {
                re = HWValidator.bytesToHexString(fileType).toUpperCase(Locale.ENGLISH);
            }
            return Optional.ofNullable(re);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        if (bytes == null || bytes.length == 0) {
            return buf.toString();
        }
        for (byte aByte : bytes) {
            int vbyte = aByte & 0xFF;
            String hexStr = Integer.toHexString(vbyte);
            if (hexStr.length() < 2) {
                buf.append(0);
            }
            buf.append(hexStr);
        }
        return buf.toString();
    }

    public static String getSecureCmd(String command) throws IllegalArgumentException {
        if (!EmptyUtils.hasLength(command)) {
            throw new IllegalArgumentException("The command is null or empty, please check your input");
        }
        String cmdBuilder = HWValidator.subSecureCmd(command);
        String secureCmd = HWValidator.commandFormat(cmdBuilder);
        return secureCmd;
    }

    private static String subSecureCmd(String command) {
        String cmdBuilder = command;
        for (String filter : COMMAND_BLACK_LISTS) {
            int cmdIndex = cmdBuilder.indexOf(filter);
            if (cmdIndex <= -1) continue;
            cmdBuilder = cmdBuilder.substring(0, cmdIndex).trim();
        }
        return cmdBuilder;
    }

    public static List<String> getSecureCmd(List<String> command) throws IllegalArgumentException {
        if (EmptyUtils.isEmpty(command)) {
            throw new IllegalArgumentException("The command is null or empty, please check your input");
        }
        ArrayList<String> secureCmd = new ArrayList<String>();
        Iterator<String> iterator = command.iterator();
        while (iterator.hasNext()) {
            String cmd;
            String cmdBuilder = cmd = iterator.next();
            cmdBuilder = HWValidator.subSecureCmd(cmdBuilder);
            secureCmd.add(HWValidator.commandFormat(cmdBuilder));
        }
        return secureCmd;
    }

    public static String[] getSecureCmd(String[] command) throws IllegalArgumentException {
        if (EmptyUtils.isEmpty(command)) {
            throw new IllegalArgumentException("The command is null or empty, please check your input");
        }
        List<String> cmdList = Arrays.asList(command);
        return HWValidator.getSecureCmd(cmdList).toArray(new String[cmdList.size()]);
    }

    public static boolean isSecureCmd(String command) throws IllegalArgumentException {
        if (!EmptyUtils.hasLength(command)) {
            throw new IllegalArgumentException("The command is null or empty, please check your input");
        }
        return HWValidator.checkIsSecureCommand(command);
    }

    private static boolean checkIsSecureCommand(String command) {
        for (String filter : COMMAND_BLACK_LISTS) {
            int cmdIndex = command.indexOf(filter);
            if (cmdIndex <= -1) continue;
            LOG.info("Your input contains characters in black lists, which may cause OS injection risks.");
            return false;
        }
        return true;
    }

    public static boolean isSecureCmd(List<String> command) throws IllegalArgumentException {
        String cmd;
        String cmdBuilder;
        if (EmptyUtils.isEmpty(command)) {
            throw new IllegalArgumentException("The command is null or empty, please check your input");
        }
        boolean isSecureCommand = true;
        Iterator<String> iterator = command.iterator();
        while (iterator.hasNext() && (isSecureCommand = HWValidator.checkIsSecureCommand(cmdBuilder = (cmd = iterator.next())))) {
        }
        return isSecureCommand;
    }

    public static void addCmdBlackLists(String blackString) throws IllegalArgumentException {
        String[] addBlackArray;
        if (blackString == null) {
            throw new IllegalArgumentException("The black String is null, please check your input");
        }
        for (String str : addBlackArray = blackString.split(",")) {
            if (!"".equals(str) && !COMMAND_BLACK_LISTS.contains(str)) {
                COMMAND_BLACK_LISTS.add(str);
                continue;
            }
            LOG.info("The black String is invalid or already exists, please check your input.");
        }
    }

    public static void removeCmdBlackLists(String blackString) throws IllegalArgumentException {
        String[] addBlackArray;
        if (blackString == null) {
            throw new IllegalArgumentException("The black String is null, please check your input");
        }
        for (String str : addBlackArray = blackString.split(",")) {
            COMMAND_BLACK_LISTS.remove(str);
        }
    }

    public static boolean isSecureCmd(String[] command) throws IllegalArgumentException {
        if (EmptyUtils.isEmpty(command)) {
            throw new IllegalArgumentException("The command is null or empty, please check your input");
        }
        List<String> cmdList = Arrays.asList(command);
        return HWValidator.isSecureCmd(cmdList);
    }

    private static String commandFormat(String command) {
        String formatCommand = command;
        int singleCount = 0;
        int doubleCount = 0;
        for (char charAt : formatCommand.toCharArray()) {
            if (charAt == '\'') {
                ++singleCount;
            }
            if (charAt != '\"') continue;
            ++doubleCount;
        }
        int singleLastIndex = formatCommand.lastIndexOf("'");
        int doubleLastIndex = formatCommand.lastIndexOf("\"");
        if ((doubleCount & 1) == 1) {
            boolean addSingleAfterDouble;
            boolean addSingleBeforeDouble = (singleCount & 1) == 1 && singleLastIndex > doubleLastIndex;
            boolean bl = addSingleAfterDouble = (singleCount & 1) == 1 && singleLastIndex < doubleLastIndex;
            if (addSingleBeforeDouble) {
                formatCommand = formatCommand.concat("'");
            }
            formatCommand = formatCommand.concat("\"");
            if (addSingleAfterDouble) {
                formatCommand = formatCommand.concat("'");
            }
        } else if ((singleCount & 1) == 1) {
            formatCommand = formatCommand.concat("'");
        }
        return formatCommand;
    }
}

