/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.base;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReDosConf {
    private static final Logger LOG = LoggerFactory.getLogger(ReDosConf.class);
    private static final Integer DEFAULT_REPETITION_SIZE = 45;
    private static final Integer DEFAULT_SAMPLE_LENGTH = 5000;
    private static final Integer DEFAULT_SAMPLE_NUMS = 3000;
    private static final Integer DEFAULT_TIME_OUT = 1000;
    private static final Integer DEFAULT_NUMS_OF_THREAD = 5;
    private static final Integer DEFAULT_MAX_ANALYSE_TIME = 120;
    private static volatile ReDosConf config = null;
    private Integer repetitionSize = DEFAULT_REPETITION_SIZE;
    private Integer sampleLength = DEFAULT_SAMPLE_LENGTH;
    private Integer sampleNums = DEFAULT_SAMPLE_NUMS;
    private Integer timeOut = DEFAULT_TIME_OUT;
    private Integer threadNums = DEFAULT_NUMS_OF_THREAD;
    private Integer maxAnalyseTime = DEFAULT_MAX_ANALYSE_TIME;

    private ReDosConf(Properties props) {
        if (props != null) {
            this.checkPropParam(props);
            LOG.info("Prop is not null, begin to initialize the prop config.");
            this.repetitionSize = (Integer)props.getOrDefault((Object)"repetitionSize", DEFAULT_REPETITION_SIZE);
            this.sampleLength = (Integer)props.getOrDefault((Object)"sampleLength", DEFAULT_SAMPLE_LENGTH);
            this.sampleNums = (Integer)props.getOrDefault((Object)"sampleNums", DEFAULT_SAMPLE_NUMS);
            this.timeOut = (Integer)props.getOrDefault((Object)"timeOut", DEFAULT_TIME_OUT);
            this.threadNums = (Integer)props.getOrDefault((Object)"threadNums", DEFAULT_NUMS_OF_THREAD);
            this.maxAnalyseTime = (Integer)props.getOrDefault((Object)"maxAnalyseTime", DEFAULT_MAX_ANALYSE_TIME);
        }
    }

    private void checkPropParam(Properties props) {
        this.checkRepetitionSize(props);
        this.checkSampleLength(props);
        this.checkSampleNums(props);
        this.checkTimeOut(props);
        this.checkThreadNums(props);
        this.checkMaxAnalyseTime(props);
    }

    private void checkMaxAnalyseTime(Properties props) {
        if (props.get("maxAnalyseTime") == null) {
            return;
        }
        Object maxAnalyseTimeObj = props.get("maxAnalyseTime");
        if (!(maxAnalyseTimeObj instanceof Integer)) {
            throw new NumberFormatException("The property is required to be an integer: maxAnalyseTime.");
        }
        int maxAnalyseTimeVal = (Integer)maxAnalyseTimeObj;
        if (maxAnalyseTimeVal < 1 || maxAnalyseTimeVal > 600) {
            throw new IllegalArgumentException("The property is illegal: maxAnalyseTime.");
        }
    }

    private void checkThreadNums(Properties props) {
        if (props.get("threadNums") == null) {
            return;
        }
        Object threadNumsObj = props.get("threadNums");
        if (!(threadNumsObj instanceof Integer)) {
            throw new NumberFormatException("The property is required to be an integer: threadNums.");
        }
        int threadNumsVal = (Integer)threadNumsObj;
        if (threadNumsVal < 1 || threadNumsVal > 100) {
            throw new IllegalArgumentException("The property is illegal: threadNums.");
        }
    }

    private void checkTimeOut(Properties props) {
        if (props.get("timeOut") == null) {
            return;
        }
        Object timeOutObj = props.get("timeOut");
        if (!(timeOutObj instanceof Integer)) {
            throw new NumberFormatException("The property is required to be an integer: timeOut.");
        }
        int timeOutVal = (Integer)timeOutObj;
        if (timeOutVal < 1 || timeOutVal > 10000) {
            throw new IllegalArgumentException("The property is illegal: timeOut.");
        }
    }

    private void checkSampleNums(Properties props) {
        if (props.get("sampleNums") == null) {
            return;
        }
        Object sampleNumsObj = props.get("sampleNums");
        if (!(sampleNumsObj instanceof Integer)) {
            throw new NumberFormatException("The property is required to be an integer: sampleNums.");
        }
        int sampleNumsVal = (Integer)sampleNumsObj;
        if (sampleNumsVal < 1 || sampleNumsVal > 10000) {
            throw new IllegalArgumentException("The property is illegal: sampleNums.");
        }
    }

    private void checkSampleLength(Properties props) {
        if (props.get("sampleLength") == null) {
            return;
        }
        Object sampleLengthObj = props.get("sampleLength");
        if (!(sampleLengthObj instanceof Integer)) {
            throw new NumberFormatException("The property is required to be an integer: sampleLength.");
        }
        int sampleLengthVal = (Integer)sampleLengthObj;
        if (sampleLengthVal < 1 || sampleLengthVal > 10000) {
            throw new IllegalArgumentException("The property is illegal: sampleLength.");
        }
    }

    private void checkRepetitionSize(Properties props) {
        if (props.get("repetitionSize") == null) {
            return;
        }
        Object repetitionSizeObj = props.get("repetitionSize");
        if (!(repetitionSizeObj instanceof Integer)) {
            throw new NumberFormatException("The property is required to be an integer: repetitionSize.");
        }
        int repetitionSizeVal = (Integer)repetitionSizeObj;
        if (repetitionSizeVal < 1 || repetitionSizeVal > 200) {
            throw new IllegalArgumentException("The property is illegal: repetitionSize.");
        }
    }

    public static ReDosConf getInstance() {
        return ReDosConf.initInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReDosConf initInstance(Properties props) {
        if (config != null) return config;
        Class<ReDosConf> clazz = ReDosConf.class;
        synchronized (ReDosConf.class) {
            if (config != null) return config;
            LOG.info("Begin to initialize the instance, only one times.");
            config = new ReDosConf(props);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return config;
        }
    }

    public Integer getRepetitionSize() {
        return this.repetitionSize;
    }

    public Integer getSampleLength() {
        return this.sampleLength;
    }

    public Integer getSampleNums() {
        return this.sampleNums;
    }

    public Integer getTimeOut() {
        return this.timeOut;
    }

    public Integer getThreadNums() {
        return this.threadNums;
    }

    public Integer getMaxAnalyseTime() {
        return this.maxAnalyseTime;
    }
}

