/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.derives;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.derives.DeriveSet;
import java.util.Collection;
import java.util.HashSet;

public class DeriveHashSet
extends HashSet<String>
implements DeriveSet {
    private static final long serialVersionUID = -7325678370206989640L;
    final int maxCapacity;

    public DeriveHashSet(int initialCapacity, int maxCapacity) {
        super(Math.min(initialCapacity, maxCapacity));
        this.maxCapacity = maxCapacity;
    }

    public DeriveHashSet(int maxCapacity, Derive ... deriveSets) {
        this(DeriveHashSet.capacity(deriveSets), maxCapacity);
        for (Derive derive : deriveSets) {
            for (String str : derive) {
                this.add(str);
            }
        }
    }

    public static DeriveSet clone(int maxCapacity, Derive derive) {
        return new DeriveHashSet(maxCapacity, derive);
    }

    private static int capacity(Derive ... deriveSets) {
        int capacity = 0;
        for (Derive derive : deriveSets) {
            capacity += derive.size();
        }
        return capacity + 1;
    }

    @Override
    public void addAll(Derive derive) {
        for (String str : derive) {
            if (this.isFull()) break;
            this.add(str);
        }
    }

    @Override
    public boolean addAll(Collection<? extends String> coll) {
        if (coll.size() + this.size() <= this.maxCapacity) {
            return super.addAll(coll);
        }
        boolean changed = false;
        for (String string : coll) {
            if (this.isFull()) break;
            changed |= this.add(string);
        }
        return changed;
    }

    @Override
    public final boolean add(String str) {
        if (!this.isFull()) {
            return super.add(str);
        }
        return false;
    }

    @Override
    public boolean isFull() {
        return this.size() >= this.maxCapacity;
    }
}

