/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.derives;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.derives.DeriveUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SeqDerive
implements Derive {
    private final Derive front;
    private final Derive back;

    public SeqDerive(Derive front, Derive back) {
        this.front = front;
        this.back = back;
    }

    @Override
    public Iterator<String> iterator() {
        return new SeqIter(this.front, this.back);
    }

    @Override
    public int size() {
        if (this.front.size() == 0) {
            return this.back.size();
        }
        if (this.back.size() == 0) {
            return this.front.size();
        }
        return Math.min(Integer.MAX_VALUE, this.front.size() * this.back.size());
    }

    @Override
    public boolean isEmpty() {
        return this.front.isEmpty() && this.back.isEmpty();
    }

    public String toString() {
        return DeriveUtils.toNormalize(this);
    }

    private static class SeqIter
    implements Iterator<String> {
        private final Derive front;
        private final Derive back;
        int size;
        int count = 0;
        private Iterator<String> frontIter;
        private Iterator<String> backIter;

        SeqIter(Derive front, Derive back) {
            this.front = front;
            this.back = back;
            this.frontIter = front.iterator();
            this.backIter = back.iterator();
            this.size = Math.min(Integer.MAX_VALUE, front.size() * back.size());
        }

        @Override
        public boolean hasNext() {
            return (this.frontIter.hasNext() || this.backIter.hasNext()) && this.count < this.size;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.frontIter.hasNext()) {
                this.frontIter = this.front.iterator();
            }
            if (!this.backIter.hasNext()) {
                this.backIter = this.back.iterator();
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.frontIter.hasNext()) {
                stringBuilder.append(this.frontIter.next());
            }
            if (this.backIter.hasNext()) {
                stringBuilder.append(this.backIter.next());
            }
            ++this.count;
            return stringBuilder.toString();
        }
    }
}

