/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.strategy.Strategy;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class RegexOptional
implements RegExp {
    private final RegExp regExp;

    public RegexOptional(RegExp regExp) {
        RegExp exp = regExp;
        if (exp instanceof RegexOptional) {
            RegexOptional optional = (RegexOptional)exp;
            exp = optional.regExp;
        }
        this.regExp = exp.toNormalize();
    }

    public static RegexOptional clone(RegExp expression) {
        return new RegexOptional(expression);
    }

    @Override
    public RegExp cross(RegExp another) {
        return this.regExp.cross(another);
    }

    @Override
    public boolean isEmpty() {
        return this.regExp.isEmpty();
    }

    @Override
    public RegExp.Match matchAt(int index, char ch) {
        return this.regExp.matchAt(index, ch);
    }

    @Override
    public Set<Integer> counts() {
        HashSet<Integer> set = new HashSet<Integer>(this.regExp.counts());
        set.add(0);
        return set;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "(%s)?", this.regExp.toString());
    }

    @Override
    public RegExp toNormalize() {
        if (this.regExp.isEmpty()) {
            return this.regExp;
        }
        return this;
    }

    @Override
    public Derive derive(Strategy strategy) {
        return strategy.optional(this.regExp.derive(strategy));
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof RegExp) {
            obj = ((RegExp)obj).toNormalize();
        }
        if (obj instanceof RegexOptional) {
            RegexOptional optional = (RegexOptional)obj;
            return this.regExp.equals(optional.regExp);
        }
        return false;
    }

    public int hashCode() {
        return this.regExp.hashCode();
    }
}

