/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.strategy.Strategy;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class RegexOr
implements RegExp {
    private final RegExp regExpA;
    private final RegExp regExpB;

    public RegexOr(RegExp regExpA, RegExp regExpB) {
        this.regExpA = regExpA.toNormalize();
        this.regExpB = regExpB.toNormalize();
    }

    public static RegexOr clone(RegExp regExpA, RegExp regExpB) {
        return new RegexOr(regExpA, regExpB);
    }

    @Override
    public boolean isEmpty() {
        return this.regExpA.isEmpty() && this.regExpB.isEmpty();
    }

    @Override
    public RegExp cross(RegExp another) {
        return RegexOr.clone(this.regExpA.cross(another), this.regExpB.cross(another)).toNormalize();
    }

    @Override
    public RegExp.Match matchAt(int index, char ch) {
        return this.regExpA.matchAt(index, ch).equals((Object)RegExp.Match.MATCH) ? RegExp.Match.MATCH : this.regExpB.matchAt(index, ch);
    }

    @Override
    public Set<Integer> counts() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.addAll(this.regExpA.counts());
        set.addAll(this.regExpB.counts());
        return set;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "(%s|%s)", this.regExpA.toString(), this.regExpB.toString());
    }

    @Override
    public RegExp toNormalize() {
        if (this.regExpA.isEmpty()) {
            return this.regExpB;
        }
        if (this.regExpB.isEmpty()) {
            return this.regExpA;
        }
        if (this.regExpA.equals(this.regExpB)) {
            return this.regExpA;
        }
        return this;
    }

    @Override
    public Derive derive(Strategy strategy) {
        return strategy.or(this.regExpA.derive(strategy), this.regExpB.derive(strategy));
    }

    public boolean equals(Object another) {
        Object obj = another;
        if (obj instanceof RegExp) {
            obj = ((RegExp)obj).toNormalize();
        }
        if (obj instanceof RegexOr) {
            RegexOr regexOr = (RegexOr)obj;
            return this.regExpA.equals(regexOr.regExpA) && this.regExpB.equals(regexOr.regExpB);
        }
        RegExp regExp = this.toNormalize();
        if (regExp instanceof RegexOr) {
            return false;
        }
        return regExp.equals(obj);
    }

    public int hashCode() {
        RegExp regExp = this.toNormalize();
        if (regExp instanceof RegexOr) {
            int prime = 31;
            int res = 1;
            res = 31 * res + this.regExpA.hashCode();
            res = 31 * res + this.regExpB.hashCode();
            return res;
        }
        return regExp.hashCode();
    }
}

