/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugCheck {
    private static final Logger log = LoggerFactory.getLogger(DebugCheck.class);
    private static final int DEFAULT_TIMEOUT = 15;

    private DebugCheck() {
    }

    public static TaskResult checkDebugPwd(ICliConnection con, DevNode devNode) {
        TaskResult result = new TaskResult();
        try {
            result.setResultObject((Object)devNode);
            result.setResult(TaskResult.Result.FAILED);
            String sshResult = "";
            sshResult = con.execCmdWithTimout("debug", 15);
            sshResult = Normalizer.normalize(sshResult, Normalizer.Form.NFKC);
            if (sshResult.trim().endsWith("Password:")) {
                DebugCheck.checkPassword(con, result, devNode);
            } else {
                result.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.notfound"));
                result.setErrorId("devicemanager.layout.device.add.deviceadddialog.developer.notfound");
            }
        }
        catch (Exception e) {
            log.error("check debug error. devnode :{} ", (Object)StringUtils.getCleanMessage((String)devNode.getIp()), (Object)e);
        }
        if (!TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
            DebugCheck.check9000DebugPwd(con, result, devNode);
        }
        return result;
    }

    private static void checkPassword(ICliConnection con, TaskResult result, DevNode devNode) throws ToolException {
        String debugPwd = devNode.getDeveloperPwd();
        String cmdResult = con.execCmdNoLogTimout(debugPwd, 15);
        if (cmdResult == null) {
            cmdResult = "";
        }
        if (DebugCheck.containsError(cmdResult = Normalizer.normalize(cmdResult, Normalizer.Form.NFKC)) || !DebugCheck.isCorrectEnd(cmdResult)) {
            result.setResult(TaskResult.Result.FAILED);
            result.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.error"));
            result.setErrorId("devicemanager.layout.device.add.deviceadddialog.developer.error");
            for (int i = 0; i < 3; ++i) {
                if (cmdResult.trim().endsWith(">")) continue;
                cmdResult = con.execCmd("exit");
            }
        } else {
            result.setResult(TaskResult.Result.SUCCESS);
            cmdResult = con.execCmd("exit");
        }
        log.info("check command result : {}", (Object)cmdResult);
    }

    private static boolean containsError(String strLine) {
        String str = Normalizer.normalize(strLine, Normalizer.Form.NFKC).toUpperCase(LanguageManager.getInstance().getCurrentLanguage()).trim();
        return str.contains("ERROR") || str.contains("NOT FOUND") || str.contains("INVALID");
    }

    private static boolean isCorrectEnd(String strLine) {
        String str = strLine.trim();
        return str.endsWith(">") || str.endsWith("#");
    }

    private static TaskResult check9000DebugPwd(ICliConnection con, TaskResult result, DevNode devNode) {
        log.info("check9000DebugPwd begin.");
        try {
            result.setResultObject((Object)devNode);
            result.setResult(TaskResult.Result.FAILED);
            String sshResult = "";
            sshResult = con.execCmdWithTimout("cli_start -u admin", 15);
            sshResult = Normalizer.normalize(sshResult, Normalizer.Form.NFKC);
            if (sshResult.trim().endsWith("password:")) {
                DebugCheck.checkPassword(con, result, devNode);
            } else {
                result.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.notfound"));
                result.setErrorId("devicemanager.layout.device.add.deviceadddialog.developer.notfound");
            }
        }
        catch (Exception e) {
            log.error("check debug 9000 error. devnode : " + StringUtils.getCleanMessage((String)devNode.getIp()), (Throwable)e);
        }
        log.info("check9000DebugPwd result:{}", (Object)result.getResult().toString());
        return result;
    }
}

