/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.devicemanager.service.AbstractDeviceService;
import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.A3000InfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.ComputeStorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.CyberEngineInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DpaInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.FusionCubeInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.utils.DeviceForbidLoginUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAddService
extends AbstractDeviceService {
    private static final Logger log = LoggerFactory.getLogger(DeviceAddService.class);
    public static final String FCE_LOGIN_ROLE_NOT_OPENAPI = "devicemanager.layout.device.add.deviceadddialog.fce.login.role.is.not.openapi";
    public static final String DEVICE_LOGIN_DEVICEDUPLICATE = "devicemanager.layout.device.add.deviceadddialog.deviceduplicate";
    public static final String SCENE_NOT_SUPPORT_DEV_TYPE_OR_VER = "devicemanager.layout.device.add.deviceadddialog.devtype.or.version.scene.notsuport";
    private final Object lock = new Object();

    public DeviceAddService(INodeTypeQuery nodeTypeQueryIntf) {
        super(nodeTypeQueryIntf);
    }

    public DeviceAddService() {
    }

    public TaskResult addDeviceByRest(DevNode devNode, DeviceOpr opr) {
        return this.addDeviceByRest(devNode, opr, false);
    }

    public TaskResult addDeviceByRest(DevNode devNode, DeviceOpr opr, boolean hasDirectPlanes) {
        INodeSupport support = null;
        DSstorageInfoQryServiceImpl restQueryService = null;
        try {
            INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
            if (nodeTypeQuery instanceof DSstorageInfoQryServiceImpl) {
                restQueryService = (DSstorageInfoQryServiceImpl)nodeTypeQuery;
            } else {
                DefaultNodeTypeQuery defNodeTypeQuery = (DefaultNodeTypeQuery)nodeTypeQuery;
                support = defNodeTypeQuery.getNodeSupport();
                restQueryService = new DSstorageInfoQryServiceImpl();
                restQueryService.setNodeSupport(support);
            }
        }
        catch (ClassCastException e) {
            log.error("get node support error.");
        }
        TaskResult taskResult = new TaskResult();
        if (restQueryService == null) {
            return this.handleQueryDevResult(devNode, taskResult);
        }
        if (devNode.isFusionCube()) {
            FusionCubeInfoQryServiceImpl fusionCubeInfoQryService = new FusionCubeInfoQryServiceImpl();
            fusionCubeInfoQryService.setNodeSupport(restQueryService.getNodeSupport());
            taskResult = fusionCubeInfoQryService.queryNodeInfo(devNode, opr);
        } else if (devNode.isA3000()) {
            A3000InfoQryServiceImpl a3000InfoQryService = new A3000InfoQryServiceImpl();
            a3000InfoQryService.setNodeSupport(restQueryService.getNodeSupport());
            taskResult = a3000InfoQryService.queryNodeInfo(devNode, opr);
        } else {
            restQueryService.setQueryDirectPlanes(hasDirectPlanes);
            taskResult = restQueryService.queryNodeInfo(devNode, opr, null);
        }
        return this.handleQueryDevResult(devNode, taskResult);
    }

    public TaskResult addDeviceByFcv(DevNode devNode, DeviceOpr opr) {
        INodeSupport support = null;
        ComputeStorageInfoQryServiceImpl restQueryService = null;
        try {
            INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
            if (nodeTypeQuery instanceof DefaultNodeTypeQuery) {
                DefaultNodeTypeQuery defNodeTypeQuery = (DefaultNodeTypeQuery)nodeTypeQuery;
                support = defNodeTypeQuery.getNodeSupport();
                restQueryService = new ComputeStorageInfoQryServiceImpl();
                restQueryService.setNodeSupport(support);
            }
        }
        catch (ClassCastException e) {
            log.error("addDeviceByFcv get node support error.");
        }
        TaskResult taskResult = new TaskResult();
        if (restQueryService == null) {
            return this.handleQueryDevResult(devNode, taskResult);
        }
        taskResult = restQueryService.queryNodeInfo(devNode, opr, null);
        log.info("addDeviceByFcv: result{}", (Object)taskResult.getResult().toString());
        return this.handleQueryDevResult(devNode, taskResult);
    }

    public TaskResult addCyberEngineDevice(DevNode devNode, DeviceOpr opr) {
        TaskResult taskResult = null;
        INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
        if (nodeTypeQuery instanceof DefaultNodeTypeQuery) {
            DefaultNodeTypeQuery defNodeTypeQuery = (DefaultNodeTypeQuery)nodeTypeQuery;
            CyberEngineInfoQryServiceImpl restQueryService = new CyberEngineInfoQryServiceImpl();
            restQueryService.setNodeSupport(defNodeTypeQuery.getNodeSupport());
            taskResult = restQueryService.queryNodeInfo(devNode, opr);
            log.info("addDeviceByFcv: result{}", (Object)taskResult.getResult().toString());
        }
        return this.handleQueryDevResult(devNode, taskResult == null ? new TaskResult() : taskResult);
    }

    public TaskResult addDpaDevice(DevNode devNode, DeviceOpr opr) {
        INodeSupport support = null;
        DpaInfoQryServiceImpl restQueryService = null;
        try {
            INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
            if (nodeTypeQuery instanceof DefaultNodeTypeQuery) {
                DefaultNodeTypeQuery defNodeTypeQuery = (DefaultNodeTypeQuery)nodeTypeQuery;
                support = defNodeTypeQuery.getNodeSupport();
                restQueryService = new DpaInfoQryServiceImpl();
                restQueryService.setNodeSupport(support);
            }
        }
        catch (ClassCastException e) {
            log.error("addDeviceByFcv get node support error.");
        }
        TaskResult taskResult = new TaskResult();
        if (restQueryService == null) {
            return this.handleQueryDevResult(devNode, taskResult);
        }
        taskResult = restQueryService.queryNodeInfo(devNode, opr, null);
        log.info("addDeviceByFcv: result{}", (Object)taskResult.getResult().toString());
        return this.handleQueryDevResult(devNode, taskResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult handleQueryDevResult(DevNode devNode, TaskResult taskResult) {
        log.info("taskResult.getResult():{}", (Object)(taskResult.getResult() == TaskResult.Result.SUCCESS ? 1 : 0));
        if (null != taskResult && taskResult.getResult() == TaskResult.Result.FAILED) {
            taskResult.setResultObject((Object)devNode);
            if (taskResult.getErrorId() != null && taskResult.getErrorId().equals(FCE_LOGIN_ROLE_NOT_OPENAPI)) {
                String errorDes = ResourceUtil.getString((String)FCE_LOGIN_ROLE_NOT_OPENAPI);
                taskResult.setErrorLocaleDescription(errorDes);
                return taskResult;
            }
            if (StringUtils.isNULLStr((String)taskResult.getErrorLocaleDescription())) {
                taskResult.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
                taskResult.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
                return taskResult;
            }
            return taskResult;
        }
        if (null != taskResult && taskResult.getResult() == TaskResult.Result.SUCCESS) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isContains(devNode)) {
                    taskResult.setErrorLocaleDescription(DEVICE_LOGIN_DEVICEDUPLICATE);
                    taskResult.setErrorId(DEVICE_LOGIN_DEVICEDUPLICATE);
                    taskResult.setResult(TaskResult.Result.FAILED);
                    return taskResult;
                }
                log.info("taskResult. start addDevNodeToDM.");
                this.addDevNodeToDM(devNode);
                log.info("taskResult. end addDevNodeToDM.");
                return taskResult;
            }
        }
        taskResult.setResult(TaskResult.Result.FAILED);
        taskResult.setErrorLocaleDescription("devicemanager.layout.device.errormsg.can.not.query.dev.type");
        taskResult.setErrorId("devicemanager.layout.device.errormsg.can.not.query.dev.type");
        return taskResult;
    }

    public TaskResult addDevice(DevNode devNode, DeviceOpr opr) {
        INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
        TaskResult taskResult = nodeTypeQuery.queryNodeInfo(devNode, opr);
        return this.handleQueryDevResult(devNode, taskResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult addDevice(DevNode devNode, DeviceOpr opr, boolean afterCheck, ProgressDialog progressDialog) {
        INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
        TaskResult result = nodeTypeQuery.queryNodeInfo(devNode, opr, progressDialog);
        if (result.getResult() == TaskResult.Result.FAILED) {
            result.setResultObject((Object)devNode);
            if (StringUtils.isNULLStr((String)result.getErrorLocaleDescription())) {
                result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
                result.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
            }
            log.error("login device failed.");
            return result;
        }
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            log.info("login device success.");
            Object object = this.lock;
            synchronized (object) {
                if (this.isContains(devNode)) {
                    result.setErrorLocaleDescription(DEVICE_LOGIN_DEVICEDUPLICATE);
                    result.setErrorId(DEVICE_LOGIN_DEVICEDUPLICATE);
                    result.setResult(TaskResult.Result.FAILED);
                }
                if (!afterCheck) {
                    this.addDevNodeToDM(devNode);
                }
                return result;
            }
        }
        result.setResult(TaskResult.Result.FAILED);
        result.setErrorLocaleDescription("devicemanager.layout.device.errormsg.can.not.query.dev.type");
        result.setErrorId("devicemanager.layout.device.errormsg.can.not.query.dev.type");
        return result;
    }

    public TaskResult addDevice(DevNode devNode, DeviceOpr opr, boolean afterCheck) {
        return this.addDevice(devNode, opr, afterCheck, null);
    }

    private boolean isContains(DevNode devNode) {
        if (DefaultNodeProviderImpl.getInstance().getNodeList().contains(devNode)) {
            return true;
        }
        List<DevNode> devNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        for (DevNode dev : devNodes) {
            if (!dev.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber())) continue;
            return true;
        }
        return false;
    }

    public boolean addDevNodeToDM(DevNode devNode) {
        try {
            DefaultNodeProviderImpl.getInstance().addNode(devNode);
            return true;
        }
        catch (ToolException e) {
            log.error("add device error.", (Throwable)e);
            return false;
        }
    }

    public boolean isDevNodeValid(DevNode devNode) {
        if (devNode == null) {
            return false;
        }
        String pwd = devNode.getLoginUser().getPassword();
        return !StringUtils.hasNULLStr((String[])new String[]{devNode.getDeviceSerialNumber(), devNode.getIp(), devNode.getLoginUser().getUserName(), pwd});
    }

    public TaskResult addDeviceParallel(ProgressDialog progressDialog, DevNode devNode, boolean aftercheck) {
        TaskResult result;
        if (ItDeviceType.COMPUTE_STORAGE.equals((Object)devNode.getStorageDeviceType())) {
            log.info("add compute storage device by fce.");
            TaskResult result2 = this.addDeviceByFcv(devNode, DeviceOpr.ADD);
            this.checkNodeAllowLogin(result2, devNode);
            return result2;
        }
        if (ItDeviceType.DPA.equals((Object)devNode.getItDeviceType())) {
            log.info("add dpa device.");
            TaskResult result3 = this.addDpaDevice(devNode, DeviceOpr.ADD);
            this.checkNodeAllowLogin(result3, devNode);
            return result3;
        }
        if (devNode.isDsStorage()) {
            log.info("add scale-out device.");
            TaskResult result4 = this.addDeviceByRest(devNode, DeviceOpr.ADD);
            this.checkNodeAllowLogin(result4, devNode);
            return result4;
        }
        if (ItDeviceType.OCEAN_CYBER.equals((Object)devNode.getItDeviceType())) {
            log.info("add OceanCyber device.");
            TaskResult result5 = this.addCyberEngineDevice(devNode, DeviceOpr.ADD);
            this.checkNodeAllowLogin(result5, devNode);
            return result5;
        }
        CountDownLatch cdl = new CountDownLatch(4);
        ParallelQueryDevTask parallelQueryDevTask = new ParallelQueryDevTask(progressDialog, devNode, cdl, aftercheck);
        if (this.getNodeTypeQueryObject() instanceof DSstorageInfoQryServiceImpl) {
            result = parallelQueryDevTask.getDeviceByRest();
        } else {
            parallelQueryDevTask.invoke();
            Future<TaskResult> restFu = parallelQueryDevTask.getRestFu();
            Future<TaskResult> fcvFu = parallelQueryDevTask.getFcvFuture();
            Future<TaskResult> restCyberEngineFu = parallelQueryDevTask.getRestCyberEngineFu();
            Future<TaskResult> cliFu = parallelQueryDevTask.getCliFu();
            Map<String, Future<TaskResult>> taskMap = this.getFutureMap(restFu, fcvFu, restCyberEngineFu, cliFu);
            result = this.getFutureResult(cdl, taskMap, devNode);
        }
        this.checkNodeAllowLogin(result, devNode);
        return result;
    }

    @NotNull
    private Map<String, Future<TaskResult>> getFutureMap(Future<TaskResult> restFu, Future<TaskResult> fcvFu, Future<TaskResult> restCyberEngineFu, Future<TaskResult> cliFu) {
        HashMap<String, Future<TaskResult>> taskMap = new HashMap<String, Future<TaskResult>>();
        taskMap.put("restFu", restFu);
        taskMap.put("fcvFu", fcvFu);
        taskMap.put("restCyberEngineFu", restCyberEngineFu);
        taskMap.put("cliFu", cliFu);
        return taskMap;
    }

    private void checkNodeAllowLogin(TaskResult result, DevNode devNode) {
        try {
            if (result != null && TaskResult.Result.SUCCESS.equals((Object)result.getResult()) && DeviceForbidLoginUtil.isForbidDev(devNode)) {
                result.setErrorLocaleDescription(DeviceForbidLoginUtil.createErrMsg(devNode));
                result.setErrorId(DeviceForbidLoginUtil.createErrMsg(devNode));
                result.setResult(TaskResult.Result.FAILED);
            }
        }
        catch (ToolException e) {
            log.error("judge Node Allow Login failed.");
            result.setErrorLocaleDescription(e.getDes());
            result.setErrorId(e.getDes());
            result.setResult(TaskResult.Result.FAILED);
        }
    }

    private TaskResult getFutureResult(CountDownLatch cdl, Map<String, Future<TaskResult>> taskMap, DevNode devNode) {
        try {
            Future<TaskResult> restFu = taskMap.get("restFu");
            Future<TaskResult> fcvFu = taskMap.get("fcvFu");
            Future<TaskResult> restCyberEngineFu = taskMap.get("restCyberEngineFu");
            Future<TaskResult> cliFu = taskMap.get("cliFu");
            cdl.await();
            Thread.sleep(1000L);
            if (fcvFu != null && fcvFu.isDone()) {
                return this.checkFcvResultFirst(fcvFu, cliFu, restFu, restCyberEngineFu, devNode);
            }
            if (restFu != null && restFu.isDone()) {
                return this.checkRestResultFirst(fcvFu, cliFu, restFu, restCyberEngineFu, devNode);
            }
            if (cliFu != null && cliFu.isDone()) {
                return this.checkCliResultFirst(fcvFu, cliFu, restFu, restCyberEngineFu, devNode);
            }
            if (restCyberEngineFu != null && restCyberEngineFu.isDone()) {
                return this.checkCyberEngineResultFirst(fcvFu, cliFu, restFu, restCyberEngineFu, devNode);
            }
        }
        catch (InterruptedException e) {
            log.error("get query future result caught interrupt exception:", (Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            log.error("get query future result caught execution exception:", (Throwable)e);
        }
        return new TaskResult();
    }

    @Nullable
    private TaskResult checkCliResultFirst(Future<TaskResult> fcvFu, Future<TaskResult> cliFu, Future<TaskResult> restFu, Future<TaskResult> restCyberEngineFu, DevNode devNode) throws InterruptedException, ExecutionException, TimeoutException {
        TaskResult restResult;
        TaskResult fcvResult;
        TaskResult cliResult = cliFu.get();
        if (this.isTaskSuccess(cliResult)) {
            return cliResult;
        }
        if (fcvFu != null && this.isTaskSuccess(fcvResult = fcvFu.get(5L, TimeUnit.MINUTES))) {
            log.info("fcv result is success.");
            return fcvResult;
        }
        if (restCyberEngineFu != null) {
            int restTimeout = 5;
            TaskResult restCyberEngineFuResult = restCyberEngineFu.get(5L, TimeUnit.MINUTES);
            if (this.isTaskSuccess(restCyberEngineFuResult)) {
                log.info("OceanCyberRest result is success.");
                return restCyberEngineFuResult;
            }
        }
        if (restFu != null && (this.isTaskSuccess(restResult = restFu.get(5L, TimeUnit.MINUTES)) || devNode.isDsStorage())) {
            log.info("check rest result success, or is ds storage:{}", (Object)devNode.isDsStorage());
            return restResult;
        }
        return cliResult;
    }

    @Nullable
    private TaskResult checkCyberEngineResultFirst(Future<TaskResult> fcvFu, Future<TaskResult> cliFu, Future<TaskResult> restFu, Future<TaskResult> restCyberEngineFu, DevNode devNode) throws InterruptedException, ExecutionException, TimeoutException {
        TaskResult restResult;
        TaskResult fcvResult;
        TaskResult cliResult;
        TaskResult restCyberEngineFuResult = restCyberEngineFu.get();
        if (this.isTaskSuccess(restCyberEngineFuResult)) {
            return restCyberEngineFuResult;
        }
        if (cliFu != null && this.isTaskSuccess(cliResult = cliFu.get(5L, TimeUnit.MINUTES))) {
            log.info("cli result is success.");
            return cliResult;
        }
        if (fcvFu != null && this.isTaskSuccess(fcvResult = fcvFu.get(5L, TimeUnit.MINUTES))) {
            log.info("fcv result is success.");
            return fcvResult;
        }
        if (restFu != null && (this.isTaskSuccess(restResult = restFu.get(5L, TimeUnit.MINUTES)) || devNode.isDsStorage())) {
            log.info("check rest result success, or is ds storage:{}", (Object)devNode.isDsStorage());
            return restResult;
        }
        return restCyberEngineFuResult;
    }

    @Nullable
    private TaskResult checkFcvResultFirst(Future<TaskResult> fcvFu, Future<TaskResult> cliFu, Future<TaskResult> restFu, Future<TaskResult> restCyberEngineFu, DevNode devNode) throws InterruptedException, ExecutionException, TimeoutException {
        TaskResult restResult;
        TaskResult restCyberEngineFuResult;
        TaskResult cliResult;
        TaskResult fcvResult = fcvFu.get();
        if (this.isTaskSuccess(fcvResult)) {
            log.info("fcvResult is success.");
            return fcvResult;
        }
        if (cliFu != null && this.isTaskSuccess(cliResult = cliFu.get(5L, TimeUnit.MINUTES))) {
            log.info("cli result is success.");
            return cliResult;
        }
        if (restCyberEngineFu != null && this.isTaskSuccess(restCyberEngineFuResult = restCyberEngineFu.get(5L, TimeUnit.MINUTES))) {
            log.info("OceanCyberRest result is success.");
            return restCyberEngineFuResult;
        }
        if (restFu != null && (this.isTaskSuccess(restResult = restFu.get(5L, TimeUnit.MINUTES)) || devNode.isDsStorage())) {
            log.info("check rest result success, or is ds storage:{}", (Object)devNode.isDsStorage());
            return restResult;
        }
        if (fcvResult != null && (FCE_LOGIN_ROLE_NOT_OPENAPI.equals(fcvResult.getErrorId()) || DEVICE_LOGIN_DEVICEDUPLICATE.equals(fcvResult.getErrorId()) || SCENE_NOT_SUPPORT_DEV_TYPE_OR_VER.equals(fcvResult.getErrorId()) || "No trusted certificate found".equals(fcvResult.getErrorId()))) {
            log.info("fcvResult is success.");
            return fcvResult;
        }
        if (cliFu != null) {
            return cliFu.get(5L, TimeUnit.MINUTES);
        }
        return fcvResult;
    }

    @Nullable
    private TaskResult checkRestResultFirst(Future<TaskResult> fcvFu, Future<TaskResult> cliFu, Future<TaskResult> restFu, Future<TaskResult> restCyberEngineFu, DevNode devNode) throws InterruptedException, ExecutionException, TimeoutException {
        TaskResult fcvResult;
        TaskResult restCyberEngineFuResult;
        TaskResult cliResult;
        TaskResult restResult = restFu.get();
        if (this.isTaskSuccess(restResult) || devNode.isDsStorage()) {
            log.info("check rest result success, or is ds storage:{}", (Object)devNode.isDsStorage());
            return restResult;
        }
        if (cliFu != null && this.isTaskSuccess(cliResult = cliFu.get(5L, TimeUnit.MINUTES))) {
            log.info("cli result is success.");
            return cliResult;
        }
        if (restCyberEngineFu != null && this.isTaskSuccess(restCyberEngineFuResult = restCyberEngineFu.get(5L, TimeUnit.MINUTES))) {
            log.info("OceanCyberRest result is success.");
            return restCyberEngineFuResult;
        }
        if (fcvFu != null && this.isTaskSuccess(fcvResult = fcvFu.get(5L, TimeUnit.MINUTES))) {
            log.info("fcv result is success.");
            return fcvResult;
        }
        return restResult;
    }

    @Nullable
    private boolean isTaskSuccess(TaskResult tResult) {
        return tResult != null && tResult.getResult() == TaskResult.Result.SUCCESS;
    }

    private class ParallelQueryDevTask {
        private ExecutorService loginDevThreadPool = ThreadPoolHelper.getFixedNumThreadPool((int)3, (String)"login_device_pool");
        private ProgressDialog progressDialog;
        private DevNode devNode;
        private CountDownLatch cdl;
        private Future<TaskResult> restFu;
        private Future<TaskResult> restCyberEngineFu;
        private Future<TaskResult> fcvFuture;
        private Future<TaskResult> cliFu;
        private boolean isAftercheck = true;

        public ParallelQueryDevTask(ProgressDialog progressDialog, DevNode devNode, CountDownLatch cdl, boolean afterCheck) {
            this.progressDialog = progressDialog;
            this.devNode = devNode;
            this.cdl = cdl;
            this.isAftercheck = afterCheck;
        }

        public ParallelQueryDevTask invoke() {
            this.restFu = this.loginDevThreadPool.submit(() -> {
                try {
                    if (!this.devNode.isNeedRestQuery()) {
                        TaskResult taskResult = null;
                        return taskResult;
                    }
                    TaskResult restRet = this.getDeviceByRest();
                    if (log.isInfoEnabled()) {
                        log.info("Query rest result : {}", (Object)TaskResult.Result.SUCCESS.equals((Object)restRet.getResult()));
                    }
                    TaskResult taskResult = restRet;
                    return taskResult;
                }
                finally {
                    this.cdl.countDown();
                }
            });
            this.queryCyberEngineDev();
            this.fcvFuture = this.loginDevThreadPool.submit(() -> {
                try {
                    if (!this.devNode.isNeedFcvQuery()) {
                        TaskResult taskResult = null;
                        return taskResult;
                    }
                    TaskResult restRet = this.getDeviceByFcv();
                    if (log.isInfoEnabled()) {
                        log.info("Query fcv result : {}", (Object)TaskResult.Result.SUCCESS.equals((Object)restRet.getResult()));
                    }
                    TaskResult taskResult = restRet;
                    return taskResult;
                }
                catch (NullPointerException ex) {
                    log.error("Failed to fcv add. null", (Throwable)ex);
                    TaskResult taskResult = new TaskResult(TaskResult.Result.FAILED);
                    return taskResult;
                }
                catch (Exception ex) {
                    log.error("Failed to fcv add.", (Throwable)ex);
                    TaskResult taskResult = new TaskResult(TaskResult.Result.FAILED);
                    return taskResult;
                }
                finally {
                    this.cdl.countDown();
                }
            });
            this.cliFu = this.loginDevThreadPool.submit(() -> {
                try {
                    TaskResult cliRet = this.getDeviceBySsh(this.devNode, this.progressDialog);
                    if (cliRet.getResult() == TaskResult.Result.SUCCESS) {
                        log.info("Cli query success.");
                    }
                    TaskResult taskResult = cliRet;
                    return taskResult;
                }
                finally {
                    this.cdl.countDown();
                }
            });
            this.threadShutdown();
            return this;
        }

        private void queryCyberEngineDev() {
            this.restCyberEngineFu = this.loginDevThreadPool.submit(() -> {
                try {
                    if (!this.devNode.isNeedRestQuery()) {
                        TaskResult taskResult = null;
                        return taskResult;
                    }
                    TaskResult restRet = this.getCyberEngineByRest();
                    log.info("Query rest result : {}", (Object)TaskResult.Result.SUCCESS.equals((Object)restRet.getResult()));
                    TaskResult taskResult = restRet;
                    return taskResult;
                }
                finally {
                    this.cdl.countDown();
                }
            });
        }

        private TaskResult getDeviceByRest() {
            return DeviceAddService.this.addDeviceByRest(this.devNode, DeviceOpr.ADD);
        }

        private TaskResult getDeviceByFcv() {
            return DeviceAddService.this.addDeviceByFcv(this.devNode, DeviceOpr.ADD);
        }

        private TaskResult getCyberEngineByRest() {
            return DeviceAddService.this.addCyberEngineDevice(this.devNode, DeviceOpr.ADD);
        }

        private TaskResult getDeviceBySsh(DevNode dev, ProgressDialog dialog) {
            return DeviceAddService.this.addDevice(dev, DeviceOpr.ADD, this.isAftercheck, dialog);
        }

        private void threadShutdown() {
            try {
                this.loginDevThreadPool.shutdown();
            }
            catch (Throwable t) {
                log.error("Thread closure exception:", t);
            }
        }

        public Future<TaskResult> getRestFu() {
            return this.restFu;
        }

        public Future<TaskResult> getRestCyberEngineFu() {
            return this.restCyberEngineFu;
        }

        public Future<TaskResult> getFcvFuture() {
            return this.fcvFuture;
        }

        public Future<TaskResult> getCliFu() {
            return this.cliFu;
        }
    }
}

