/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.devicemanager.service.DeviceAddService;
import com.huawei.ism.tool.devicemanager.service.DeviceImportService;
import com.huawei.ism.tool.devicemanager.service.DeviceModifyService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.IDeviceManageService;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;

public class DeviceManageService
implements IDeviceManageService {
    private DeviceAddService deviceAddService = null;
    private DeviceModifyService deviceModifyService = new DeviceModifyService();
    private DeviceImportService deviceImportService = new DeviceImportService();

    public DeviceManageService(INodeTypeQuery nodeTypeQueryIntf) {
        this.deviceAddService = new DeviceAddService(nodeTypeQueryIntf);
    }

    public DeviceManageService() {
        this.deviceAddService = new DeviceAddService();
    }

    @Override
    public TaskResult addDeviceBySsh(DevNode devNode) {
        return this.deviceAddService.addDevice(devNode, DeviceOpr.ADD);
    }

    @Override
    public TaskResult addDeviceByFcv(DevNode devNode) {
        return this.deviceAddService.addDeviceByFcv(devNode, DeviceOpr.ADD);
    }

    @Override
    public TaskResult addDpaDevice(DevNode devNode) {
        return this.deviceAddService.addDpaDevice(devNode, DeviceOpr.ADD);
    }

    @Override
    public TaskResult addDeviceByRest(DevNode devNode) {
        return this.deviceAddService.addDeviceByRest(devNode, DeviceOpr.ADD);
    }

    @Override
    public TaskResult addDeviceBySsh(DevNode devNode, boolean afterCheck) {
        return this.deviceAddService.addDevice(devNode, DeviceOpr.ADD, afterCheck);
    }

    @Override
    public TaskResult addDeviceBySsh(DevNode devNode, boolean afterCheck, ProgressDialog progressDialog) {
        return this.deviceAddService.addDevice(devNode, DeviceOpr.ADD, afterCheck, progressDialog);
    }

    @Override
    public void deleteDevice(DevNode devNode) {
    }

    @Override
    public TaskResult modifyDevice(DevNode devNode, DeviceOpr opr) {
        return this.deviceModifyService.modifyDevice(devNode, opr);
    }

    @Override
    public TaskResult importDevice(DevNode devNode) {
        return this.deviceImportService.importDevice(devNode);
    }

    @Override
    public boolean isDevNodeExist(DevNode devNode) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().contains(devNode);
    }

    @Override
    public boolean addDevNodeToDM(DevNode devNode) {
        return this.deviceAddService.addDevNodeToDM(devNode);
    }

    @Override
    public TaskResult addDeviceParallel(ProgressDialog progressDialog, DevNode devNode, boolean afterCheck) {
        return this.deviceAddService.addDeviceParallel(progressDialog, devNode, afterCheck);
    }
}

