/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.huawei.ism.tool.devicemanager.service.host.AixHostServiceImpl;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.HpuxHostServiceImpl;
import com.huawei.ism.tool.devicemanager.service.host.LinuxHostServiceImpl;
import com.huawei.ism.tool.devicemanager.service.host.SolarisHostServiceImpl;
import com.huawei.ism.tool.devicemanager.service.host.VMwareHostServiceImpl;
import com.huawei.ism.tool.devicemanager.service.host.WindowsHostServiceImpl;
import com.huawei.ism.tool.obase.entity.DevNode;

public class HostServiceFactory {
    public static HostService createHostService(DevNode devNode) {
        String deviceName = devNode.getDeviceName();
        if ("linux".equalsIgnoreCase(deviceName) || "fusionsphere".equalsIgnoreCase(deviceName)) {
            return new LinuxHostServiceImpl();
        }
        if ("aix".equalsIgnoreCase(devNode.getDeviceName())) {
            return new AixHostServiceImpl();
        }
        if ("hp-ux".equalsIgnoreCase(deviceName)) {
            return new HpuxHostServiceImpl();
        }
        if ("solaris".equalsIgnoreCase(deviceName)) {
            return new SolarisHostServiceImpl();
        }
        if ("vmware".equalsIgnoreCase(deviceName) || "esxi".equalsIgnoreCase(deviceName)) {
            return new VMwareHostServiceImpl();
        }
        if ("windows".equalsIgnoreCase(devNode.getDeviceName())) {
            return new WindowsHostServiceImpl();
        }
        return null;
    }
}

